/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.entity.remotelink;

import com.atlassian.greenhopper.entity.remotelink.RemoteEntityLinkService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyQuery;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class RemoteEntityLinkServiceImpl
implements RemoteEntityLinkService {
    @Override
    public String putEntityPropertyValue(String remoteLinkName, String globalId, String json, Long entityId) {
        Assertions.notNull((String)"entityId", (Object)entityId);
        Assertions.notNull((String)"json", (Object)json);
        JsonEntityPropertyManager jsonEntityPropertyManager = (JsonEntityPropertyManager)ComponentAccessor.getComponent(JsonEntityPropertyManager.class);
        jsonEntityPropertyManager.put(remoteLinkName, entityId, globalId, json);
        return globalId;
    }

    @Override
    public List<EntityProperty> findByEntityId(String remoteLinkName, Long entityId) {
        JsonEntityPropertyManager jsonEntityPropertyManager = (JsonEntityPropertyManager)ComponentAccessor.getComponent(JsonEntityPropertyManager.class);
        return ((EntityPropertyQuery.ExecutableQuery)jsonEntityPropertyManager.query().entityName(remoteLinkName).entityId(entityId)).find();
    }

    @Override
    public List<EntityProperty> findByGlobalId(String remoteLinkName, String globalId) {
        JsonEntityPropertyManager jsonEntityPropertyManager = (JsonEntityPropertyManager)ComponentAccessor.getComponent(JsonEntityPropertyManager.class);
        return jsonEntityPropertyManager.query().entityName(remoteLinkName).key(globalId).find();
    }

    @Override
    public EntityProperty get(String remoteLinkName, Long entityId, String globalId) {
        JsonEntityPropertyManager jsonEntityPropertyManager = (JsonEntityPropertyManager)ComponentAccessor.getComponent(JsonEntityPropertyManager.class);
        return jsonEntityPropertyManager.get(remoteLinkName, entityId, globalId);
    }

    @Override
    public void delete(String remoteLinkName, Long entityId, String globalId) {
        JsonEntityPropertyManager jsonEntityPropertyManager = (JsonEntityPropertyManager)ComponentAccessor.getComponent(JsonEntityPropertyManager.class);
        jsonEntityPropertyManager.delete(remoteLinkName, entityId, globalId);
    }

    @Override
    public void deleteAll(String remoteLinkName, Long entityId) {
        JsonEntityPropertyManager jsonEntityPropertyManager = (JsonEntityPropertyManager)ComponentAccessor.getComponent(JsonEntityPropertyManager.class);
        jsonEntityPropertyManager.deleteByEntity(remoteLinkName, entityId);
    }
}

