/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.sprint;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.statistics.AbstractCustomFieldStatisticsMapper;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestUtils;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.Operand;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import java.util.Comparator;

public class SprintStatisticsMapper
extends AbstractCustomFieldStatisticsMapper
implements StatisticsMapper {
    private final CustomField sprintCustomField;
    private final Comparator<Sprint> comparator;
    private final SprintService sprintService;
    private final ApplicationUser requestUser;
    private final SearchService searchService;

    public SprintStatisticsMapper(CustomField sprintCustomField, Comparator<Sprint> comparator, SprintService sprintService, ApplicationUser requestUser, SearchService searchService) {
        super(sprintCustomField);
        this.sprintCustomField = sprintCustomField;
        this.comparator = comparator;
        this.sprintService = sprintService;
        this.requestUser = requestUser;
        this.searchService = searchService;
    }

    public String getDocumentConstant() {
        return this.sprintCustomField.getId();
    }

    public Sprint getValueFromLuceneField(String documentValue) {
        if (documentValue == null) {
            return null;
        }
        ServiceOutcome<Sprint> serviceOutcome = this.sprintService.getSprint(this.requestUser, Long.valueOf(documentValue));
        return serviceOutcome.isInvalid() ? null : serviceOutcome.getValue();
    }

    protected String getSearchValue(Object value) {
        Sprint sprint = (Sprint)value;
        return sprint.getId().toString();
    }

    public Comparator<Sprint> getComparator() {
        return this.comparator;
    }

    public boolean equals(Object o) {
        if (o instanceof SprintStatisticsMapper) {
            SprintStatisticsMapper that = (SprintStatisticsMapper)((Object)o);
            return Objects.equal((Object)this.sprintCustomField, (Object)that.sprintCustomField) && Objects.equal(this.comparator, that.comparator) && Objects.equal((Object)this.sprintService, (Object)that.sprintService) && Objects.equal((Object)this.requestUser, (Object)that.requestUser);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sprintCustomField, this.comparator, this.sprintService, this.requestUser});
    }

    public SearchRequest getSearchUrlSuffix(Object value, SearchRequest searchRequest) {
        if (searchRequest == null) {
            return null;
        }
        if (this.isSearchRenderShown(value, searchRequest)) {
            return this.buildSprintSearchRequest(value, searchRequest);
        }
        return null;
    }

    private boolean isSearchRenderShown(Object value, SearchRequest searchRequest) {
        CustomFieldSearcher searcher = this.customField.getCustomFieldSearcher();
        return searcher.getSearchRenderer().isShown(this.requestUser, this.getCombinedSearchContext(value, searchRequest));
    }

    private SearchContext getCombinedSearchContext(Object value, SearchRequest searchRequest) {
        SearchContext searchRequestContext = this.searchService.getSearchContext(this.requestUser, searchRequest.getQuery());
        SearchContext possibleContext = this.getSearchContextFromValue(value);
        return SearchRequestUtils.getCombinedSearchContext((SearchContext)searchRequestContext, (SearchContext)possibleContext);
    }

    @VisibleForTesting
    protected SearchRequest buildSprintSearchRequest(Object value, SearchRequest searchRequest) {
        JqlClauseBuilder whereClauseBuilder = JqlQueryBuilder.newClauseBuilder((Query)searchRequest.getQuery()).defaultAnd();
        if (value != null) {
            whereClauseBuilder.addNumberCondition(this.customField.getFieldName(), Long.valueOf(this.getSearchValue(value)));
        } else {
            whereClauseBuilder.addCondition(this.customField.getFieldName(), (Operand)EmptyOperand.EMPTY);
        }
        return new SearchRequest(whereClauseBuilder.buildQuery());
    }
}

