/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.sprint;

import com.atlassian.greenhopper.customfield.JiraCustomFieldUtilsService;
import com.atlassian.greenhopper.customfield.sprint.SprintCFType;
import com.atlassian.greenhopper.customfield.sprint.SprintClauseQueryFactory;
import com.atlassian.greenhopper.customfield.sprint.SprintClauseValidator;
import com.atlassian.greenhopper.customfield.sprint.SprintClauseValueGenerator;
import com.atlassian.greenhopper.customfield.sprint.SprintCustomFieldIndexer;
import com.atlassian.greenhopper.customfield.sprint.SprintResolver;
import com.atlassian.greenhopper.customfield.sprint.SprintSearchInputTransformer;
import com.atlassian.greenhopper.customfield.sprint.SprintSearchRenderer;
import com.atlassian.greenhopper.customfield.sprint.SprintStatisticsMapper;
import com.atlassian.greenhopper.service.BridgeServiceLocator;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.greenhopper.service.sprint.SprintUtils;
import com.atlassian.greenhopper.web.rapid.sprint.SprintHelper;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.SortableCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldContextValueGeneratingClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldStattable;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.SimpleClauseContextFactory;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;

public class SprintSearcher
extends AbstractInitializationCustomFieldSearcher
implements CustomFieldSearcher,
SortableCustomFieldSearcher,
CustomFieldStattable {
    private final FieldVisibilityManager fieldVisibilityManager;
    private final JqlOperandResolver jqlOperandResolver;
    private final CustomFieldInputHelper customFieldInputHelper;
    private final JqlDateSupport jqlDateSupport;
    private final I18nHelper.BeanFactory i18nFactory;
    private final VelocityRequestContextFactory velocityRenderContext;
    private final ApplicationProperties applicationProperties;
    private JiraCustomFieldUtilsService jiraCustomFieldUtils;
    private final VelocityTemplatingEngine templatingEngine;
    private final SprintHelper sprintHelper;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private volatile CustomFieldSearcherInformation searcherInformation;
    private volatile SearchInputTransformer searchInputTransformer;
    private volatile SearchRenderer searchRenderer;
    private volatile CustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;
    private volatile SearchService searchService;
    private volatile SprintService sprintService;

    public SprintSearcher(FieldVisibilityManager fieldVisibilityManager, JqlOperandResolver jqlOperandResolver, CustomFieldInputHelper customFieldInputHelper, JqlDateSupport jqlDateSupport, I18nHelper.BeanFactory i18nFactory, VelocityRequestContextFactory velocityRenderContext, ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext, SearchService searchService, JiraCustomFieldUtilsService jiraCustomFieldUtils) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.jqlOperandResolver = jqlOperandResolver;
        this.searchService = searchService;
        this.customFieldInputHelper = customFieldInputHelper;
        this.jqlDateSupport = jqlDateSupport;
        this.i18nFactory = i18nFactory;
        this.velocityRenderContext = velocityRenderContext;
        this.applicationProperties = applicationProperties;
        this.jiraCustomFieldUtils = jiraCustomFieldUtils;
        this.templatingEngine = (VelocityTemplatingEngine)ComponentAccessor.getComponent(VelocityTemplatingEngine.class);
        this.sprintHelper = BridgeServiceLocator.getInstance().getSprintHelper();
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public void init(CustomField field) {
        ClauseNames names = field.getClauseNames();
        SprintCustomFieldIndexer indexer = new SprintCustomFieldIndexer(this.fieldVisibilityManager, field);
        this.searcherInformation = new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field));
        this.searchRenderer = new SprintSearchRenderer(field.getId(), this.velocityRenderContext, this.applicationProperties, this.templatingEngine, field, this.sprintHelper, this.jiraCustomFieldUtils);
        this.searchInputTransformer = new SprintSearchInputTransformer(field, names, this.jqlOperandResolver, this.searcherInformation.getId(), this.customFieldInputHelper);
        SprintResolver sprintResolver = new SprintResolver();
        this.customFieldSearcherClauseHandler = new SimpleCustomFieldContextValueGeneratingClauseHandler((ClauseValidator)new SprintClauseValidator(sprintResolver, this.jqlOperandResolver, OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, this.i18nFactory), (ClauseQueryFactory)new SprintClauseQueryFactory(this.jqlOperandResolver, sprintResolver, field), (ClauseContextFactory)new SimpleClauseContextFactory(), (ClauseValuesGenerator)new SprintClauseValueGenerator(this.jqlDateSupport, sprintResolver), OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, SprintCFType.SPRINT);
        this.sprintService = (SprintService)ComponentAccessor.getOSGiComponentInstanceOfType(SprintService.class);
    }

    public SearcherInformation<CustomField> getSearchInformation() {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve SearcherInformation off uninitialised custom field searcher.");
        }
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        if (this.searchInputTransformer == null) {
            throw new IllegalStateException("Attempt to retrieve searchInputTransformer off uninitialised custom field searcher.");
        }
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        if (this.searchRenderer == null) {
            throw new IllegalStateException("Attempt to retrieve searchRenderer off uninitialised custom field searcher.");
        }
        return this.searchRenderer;
    }

    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        if (this.customFieldSearcherClauseHandler == null) {
            throw new IllegalStateException("Attempt to retrieve customFieldSearcherClauseHandler off uninitialised custom field searcher.");
        }
        return this.customFieldSearcherClauseHandler;
    }

    public LuceneFieldSorter getSorter(CustomField customField) {
        return this.getStatisticsMapper(customField);
    }

    public StatisticsMapper getStatisticsMapper(CustomField customField) {
        return new SprintStatisticsMapper(customField, (Comparator<Sprint>)SprintUtils.SPRINT_NATURAL_COMPARATOR, this.sprintService, this.jiraAuthenticationContext.getUser(), this.searchService);
    }
}

