/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.sprint;

import com.atlassian.greenhopper.customfield.JiraCustomFieldUtilsService;
import com.atlassian.greenhopper.customfield.sprint.SprintSearcherEditModel;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.web.rapid.sprint.SprintHelper;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.query.Query;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import webwork.action.Action;

public class SprintSearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    private final CustomField customField;
    private final SprintHelper sprintHelper;
    private final JiraCustomFieldUtilsService jiraCustomFieldUtils;

    public SprintSearchRenderer(String searcherId, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, CustomField customField, SprintHelper sprintHelper, JiraCustomFieldUtilsService jiraCustomFieldUtils) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, searcherId, "navigator.filter." + customField.getId());
        this.customField = customField;
        this.sprintHelper = sprintHelper;
        this.jiraCustomFieldUtils = jiraCustomFieldUtils;
    }

    public String getEditHtml(ApplicationUser searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map velocityParams = this.getVelocityParams(searcher, searchContext, null, fieldValuesHolder, displayParameters, action);
        velocityParams.put("sprintCustomFieldId", this.customField.getId());
        HashSet suggestedSprints = Sets.newHashSet(this.sprintHelper.findSprintsByNameInHistory(searcher, "", 50, false));
        velocityParams.put("suggestedSprints", this.transformToSprintPickerModel(searcher, suggestedSprints));
        velocityParams.put("allSprints", this.transformToSprintPickerModel(searcher, this.sprintHelper.findSprintPickerAllMatches(searcher, suggestedSprints, "", 50, false).getValue()));
        CustomFieldParams customFieldParams = (CustomFieldParams)fieldValuesHolder.get((Object)this.customField.getId());
        Set<Object> selectedSprints = Sets.newHashSet();
        if (customFieldParams != null) {
            velocityParams.put("selectedSprintIds", customFieldParams.getAllValues());
            selectedSprints = this.getSelectedSprints(customFieldParams);
        }
        velocityParams.put("selectedSprints", Sets.newHashSet(this.transformToSprintPickerModel(searcher, selectedSprints)));
        return this.renderEditTemplate("sprint-searcher-edit.vm", velocityParams);
    }

    public String getViewHtml(ApplicationUser searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map velocityParams = this.getVelocityParams(searcher, searchContext, null, fieldValuesHolder, displayParameters, action);
        velocityParams.put("sprintCustomFieldId", this.customField.getId());
        CustomFieldParams customFieldParams = (CustomFieldParams)fieldValuesHolder.get((Object)this.customField.getId());
        Set<Object> selectedSprints = Collections.emptySet();
        if (customFieldParams != null) {
            selectedSprints = this.getSelectedSprints(customFieldParams);
        }
        velocityParams.put("selectedSprints", selectedSprints);
        return this.renderViewTemplate("sprint-searcher-view.vm", velocityParams);
    }

    public boolean isRelevantForQuery(ApplicationUser searcher, Query query) {
        return this.isRelevantForQuery(this.customField.getClauseNames(), query);
    }

    public boolean isShown(ApplicationUser searcher, SearchContext searchContext) {
        return this.jiraCustomFieldUtils.isShownAndVisible(this.customField, searcher, searchContext);
    }

    @VisibleForTesting
    Sprint getSprintFromIdObj(Object idObj) {
        String sprintIdString = "";
        if (idObj instanceof String) {
            sprintIdString = (String)idObj;
        } else if (idObj instanceof Long) {
            sprintIdString = String.valueOf(idObj);
        }
        try {
            Object sprint = this.customField.getCustomFieldType().getSingularObjectFromString(sprintIdString);
            return sprint instanceof Sprint ? (Sprint)sprint : null;
        }
        catch (FieldValidationException fieldValidationException) {
            return null;
        }
    }

    private Set<SprintSearcherEditModel> transformToSprintPickerModel(final ApplicationUser searcher, Set<Sprint> sprints) {
        return Sets.newHashSet((Iterable)Iterables.transform(sprints, (Function)new Function<Sprint, SprintSearcherEditModel>(){

            public SprintSearcherEditModel apply(Sprint sprint) {
                SprintSearcherEditModel sprintSearcherEditModel = new SprintSearcherEditModel();
                sprintSearcherEditModel.setId(sprint.getId());
                sprintSearcherEditModel.setName(sprint.getName());
                sprintSearcherEditModel.setBoardName(SprintSearchRenderer.this.sprintHelper.getBoardNameForSprint(searcher, sprint));
                sprintSearcherEditModel.setStateKey(sprint.getState().toString().toUpperCase());
                sprintSearcherEditModel.setDate(SprintSearchRenderer.this.getRelevantDateForSprint(sprint));
                return sprintSearcherEditModel;
            }
        }));
    }

    private String getRelevantDateForSprint(Sprint sprint) {
        switch (sprint.getState()) {
            case ACTIVE: {
                return sprint.getStartDate() != null ? sprint.getStartDate().toString("YYYY-MM-dd'T'HH:mm:s'Z'") : "";
            }
            case CLOSED: {
                return sprint.getCompleteDate() != null ? sprint.getCompleteDate().toString("YYYY-MM-dd'T'HH:mm:s'Z'") : "";
            }
        }
        return "";
    }

    private Set<Sprint> getSelectedSprints(CustomFieldParams customFieldParams) {
        return Sets.newHashSet((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)customFieldParams.getAllValues(), (Function)new Function(){

            public Object apply(Object id) {
                return SprintSearchRenderer.this.getSprintFromIdObj(id);
            }
        }), (Predicate)Predicates.notNull()));
    }
}

