/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.sprint;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.customfields.searchers.transformer.AbstractCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.impl.NamedTerminalClauseCollectingVisitor;
import com.atlassian.jira.issue.search.searchers.transformer.FieldFlagOperandRegistry;
import com.atlassian.jira.issue.search.searchers.transformer.NavigatorStructureChecker;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class SprintSearchInputTransformer
extends AbstractCustomFieldSearchInputTransformer {
    private final ClauseNames clauseNames;
    private final FieldFlagOperandRegistry fieldFlagOperandRegistry;
    private final JqlOperandResolver operandResolver;

    public SprintSearchInputTransformer(CustomField field, ClauseNames clauseNames, JqlOperandResolver operandResolver, String urlParameterName, CustomFieldInputHelper customFieldInputHelper) {
        super(field, urlParameterName, customFieldInputHelper);
        this.clauseNames = clauseNames;
        this.fieldFlagOperandRegistry = (FieldFlagOperandRegistry)ComponentAccessor.getComponent(FieldFlagOperandRegistry.class);
        this.operandResolver = operandResolver;
    }

    public boolean doRelevantClausesFitFilterForm(ApplicationUser searcher, Query query, SearchContext searchContext) {
        return new NavigatorStructureChecker(this.clauseNames, false, this.fieldFlagOperandRegistry, this.operandResolver).checkSearchRequest(query, searchContext);
    }

    protected Clause getClauseFromParams(ApplicationUser user, CustomFieldParams customFieldParams) {
        Collection searchValues = customFieldParams.getValuesForNullKey();
        if (searchValues != null && searchValues.size() > 0) {
            ArrayList operands = Lists.newArrayListWithCapacity((int)searchValues.size());
            for (Object idObj : searchValues) {
                SingleValueOperand operand;
                if (idObj.equals("-1") || (operand = this.getSprintOperandForIdObj(idObj)) == null || operands.contains(operand)) continue;
                operands.add(operand);
            }
            if (operands.size() == 1) {
                return new TerminalClauseImpl(this.getClauseName(user, this.clauseNames), Operator.EQUALS, (Operand)operands.get(0));
            }
            if (operands.size() > 1) {
                return new TerminalClauseImpl(this.getClauseName(user, this.clauseNames), Operator.IN, (Operand)new MultiValueOperand((Collection)operands));
            }
        }
        return null;
    }

    protected CustomFieldParams getParamsFromSearchRequest(ApplicationUser user, Query query, SearchContext searchContext) {
        LinkedHashSet<Long> allValues = new LinkedHashSet<Long>();
        List<TerminalClause> clauses = this.getMatchingClauses(query);
        for (TerminalClause clause : clauses) {
            allValues.addAll(this.getAllNavigatorValues(clause.getOperand(), clause));
        }
        return new CustomFieldParamsImpl(this.getCustomField(), allValues);
    }

    private SingleValueOperand getSprintOperandForIdObj(Object idObj) {
        Long id = -1L;
        if (idObj instanceof Long) {
            id = (Long)idObj;
        } else if (idObj instanceof String) {
            id = Long.valueOf((String)idObj);
        }
        return new SingleValueOperand(id);
    }

    private List<TerminalClause> getMatchingClauses(Query query) {
        NamedTerminalClauseCollectingVisitor collectorVisitor = new NamedTerminalClauseCollectingVisitor("Sprint");
        if (query != null && query.getWhereClause() != null) {
            query.getWhereClause().accept((ClauseVisitor)collectorVisitor);
            return collectorVisitor.getNamedClauses();
        }
        return Collections.EMPTY_LIST;
    }

    private Set<Long> getAllNavigatorValues(Operand operand, TerminalClause clause) {
        if (operand instanceof MultiValueOperand) {
            MultiValueOperand multiValueOperand = (MultiValueOperand)operand;
            LinkedHashSet<Long> values = new LinkedHashSet<Long>();
            for (Operand subOperand : multiValueOperand.getValues()) {
                values.addAll(this.getAllNavigatorValues(subOperand, clause));
            }
            return values;
        }
        if (operand instanceof SingleValueOperand) {
            SingleValueOperand singleValueOperand = (SingleValueOperand)operand;
            LinkedHashSet<Long> values = new LinkedHashSet<Long>();
            if (singleValueOperand.getLongValue() != null) {
                values.add(singleValueOperand.getLongValue());
            }
            return values;
        }
        return Collections.EMPTY_SET;
    }
}

