/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.sprint;

import com.atlassian.greenhopper.customfield.RestFieldSetOperationsHelper;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.ServiceResultImpl;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintCustomFieldService;
import com.atlassian.greenhopper.service.sprint.SprintService;
import com.atlassian.greenhopper.service.sprint.SprintUtils;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.rest.FieldOperationHolder;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SprintRestFieldOperationsHandler
implements RestFieldOperationsHandler {
    private final RestFieldSetOperationsHelper restFieldSetOperationsHelper;
    private final SprintService sprintService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final SprintCustomFieldService sprintCustomFieldService;

    @Autowired
    public SprintRestFieldOperationsHandler(RestFieldSetOperationsHelper restFieldSetOperationsHelper, SprintService sprintService, JiraAuthenticationContext jiraAuthenticationContext, SprintCustomFieldService sprintCustomFieldService) {
        this.restFieldSetOperationsHelper = restFieldSetOperationsHelper;
        this.sprintService = sprintService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.sprintCustomFieldService = sprintCustomFieldService;
    }

    public Set<String> getSupportedOperations() {
        return this.restFieldSetOperationsHelper.getSetOperation();
    }

    public ErrorCollection updateIssueInputParameters(IssueContext issueCtx, @Nullable Issue issue, String fieldId, IssueInputParameters inputParameters, List<FieldOperationHolder> operations) {
        return this.restFieldSetOperationsHelper.updateIssueInputParameters(operations, (Function<JsonData, ServiceResult>)((Function)data -> {
            ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
            if (issueCtx.getIssueType() != null && issueCtx.getIssueType().isSubTask()) {
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.issue.move.error.subtask", this.getIssueKey(issue));
            }
            if (data.isNull()) {
                List<Sprint> existingSprints = this.getExistingClosedSprints(issue);
                inputParameters.addCustomFieldValue(fieldId, this.getSprintsInFieldFormat(existingSprints));
                return ServiceResultImpl.ok();
            }
            ServiceOutcome<Long> sprintIdOutcome = this.getSprintId((JsonData)data);
            if (sprintIdOutcome.isInvalid()) {
                return ServiceResultImpl.from(sprintIdOutcome.getErrors());
            }
            Long sprintId = sprintIdOutcome.get();
            ServiceOutcome<Sprint> sprintOutcome = this.sprintService.getSprint(user, sprintId);
            if (sprintOutcome.isInvalid()) {
                return ServiceResultImpl.from(sprintOutcome.getErrors());
            }
            Sprint sprint = sprintOutcome.get();
            if (sprint.isClosed()) {
                return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.active.or.future.sprint.expected", this.getIssueKey(issue));
            }
            List<Sprint> sprintsToSave = this.appendToExistingSprints(issue, sprint);
            inputParameters.addCustomFieldValue(fieldId, this.getSprintsInFieldFormat(sprintsToSave));
            return ServiceResultImpl.ok();
        }));
    }

    private List<Sprint> getExistingClosedSprints(@Nullable Issue issue) {
        if (issue == null) {
            return Collections.emptyList();
        }
        Collection existingSprints = (Collection)this.sprintCustomFieldService.getDefaultSprintField().getValue(issue);
        if (existingSprints == null) {
            return Collections.emptyList();
        }
        return existingSprints.stream().filter(arg_0 -> SprintUtils.SPRINT_CLOSED.apply(arg_0)).collect(Collectors.toList());
    }

    private String[] getSprintsInFieldFormat(List<Sprint> sprintsToSave) {
        return (String[])sprintsToSave.stream().map(sprint -> sprint.getId().toString()).toArray(String[]::new);
    }

    private List<Sprint> appendToExistingSprints(Issue issue, Sprint sprint) {
        List<Sprint> existingSprints = this.getExistingClosedSprints(issue);
        return ImmutableList.builder().add((Object)sprint).addAll(existingSprints).build();
    }

    public ServiceOutcome<Long> getSprintId(JsonData data) {
        Object objectData = data.getData();
        if (objectData instanceof Number) {
            return ServiceOutcomeImpl.ok(((Number)objectData).longValue());
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.sprint.error.id.number.expected", new Object[0]);
    }

    private String getIssueKey(@Nullable Issue issue) {
        return issue != null ? issue.getKey() : "";
    }
}

