/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.sprint;

import com.atlassian.greenhopper.customfield.sprint.SprintNameContains;
import com.atlassian.greenhopper.service.BridgeServiceLocator;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.service.sprint.SprintPermissionService;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;

public class SprintResolver {
    public boolean checkSprintAccessible(ApplicationUser searcher, Long sprintId) {
        ServiceOutcome<Sprint> sprintOutcome = this.getSprintManager().getSprint(sprintId);
        if (sprintOutcome.isValid()) {
            ServiceOutcome<Boolean> permissionOutcome = this.getSprintPermissionService().canViewSprint(searcher, sprintOutcome.getValue());
            return permissionOutcome.isValid() && permissionOutcome.getValue() != false;
        }
        return false;
    }

    public Collection<Long> findSprintIdsByName(ApplicationUser user, boolean overrideSecurity, String sprintNameCriteria) {
        return Lists.newArrayList((Iterable)Iterables.transform(this.findSprintByPredicate(user, overrideSecurity, new SprintNameContains(sprintNameCriteria)), (Function)new SprintToLong()));
    }

    public Collection<Sprint> findSprintByPredicate(ApplicationUser user, boolean overrideSecurity, Predicate<Sprint> predicate) {
        ServiceOutcome<Collection<Sprint>> sprintsOutcome = this.getSprintManager().getAllSprints();
        if (sprintsOutcome.isValid()) {
            Predicate combinedPredicate = overrideSecurity ? predicate : Predicates.and(predicate, (Predicate)new SprintAccessible(this, user));
            return Lists.newArrayList((Iterable)Iterables.filter((Iterable)sprintsOutcome.getValue(), combinedPredicate));
        }
        return Collections.emptySet();
    }

    public Iterable<Sprint> findSprintByPredicate(ApplicationUser user, boolean overrideSecurity, Predicate<Sprint> predicate, int maxNumResults) {
        return Iterables.limit(this.findSprintByPredicate(user, overrideSecurity, predicate), (int)maxNumResults);
    }

    private SprintManager getSprintManager() {
        return BridgeServiceLocator.getInstance().getSprintManager();
    }

    private SprintPermissionService getSprintPermissionService() {
        return BridgeServiceLocator.getInstance().getSprintPermissionService();
    }

    private static class SprintAccessible
    implements Predicate<Sprint> {
        private final SprintResolver sprintResolver;
        private final ApplicationUser user;

        public SprintAccessible(SprintResolver sprintResolver, ApplicationUser user) {
            this.sprintResolver = sprintResolver;
            this.user = user;
        }

        public boolean apply(Sprint sprint) {
            return this.sprintResolver.checkSprintAccessible(this.user, sprint.getId());
        }
    }

    private static class SprintToLong
    implements Function<Sprint, Long> {
        private SprintToLong() {
        }

        public Long apply(Sprint sprint) {
            return sprint.getId();
        }
    }
}

