/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.sprint;

import com.atlassian.greenhopper.customfield.sprint.SprintHistoryData;
import com.atlassian.greenhopper.customfield.sprint.SprintHistoryEntry;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.util.DateUtils;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.history.ChangeItemBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SprintHistoryEntryFactory {
    private static final LoggerWrapper log = LoggerWrapper.with(SprintHistoryEntryFactory.class);
    @Autowired
    private ChangeHistoryManager changeHistoryManager;
    @Autowired
    private SprintManager sprintManager;

    public SprintHistoryData getSprintChangeHistory(Issue issue, CustomField sprintCustomField) {
        if (!issue.isSubTask()) {
            return this.getSprintChangeHistoryForIssue(issue, sprintCustomField);
        }
        Issue parent = issue.getParentObject();
        if (parent == null) {
            log.warn("Unable to fetch parent issue for %s", issue.getKey());
            return this.getSprintChangeHistoryForIssue(issue, sprintCustomField);
        }
        SprintHistoryData parentHistory = this.getSprintChangeHistoryForIssue(parent, sprintCustomField);
        return this.reduceToSubtaskLifetime(issue, parentHistory);
    }

    private SprintHistoryData reduceToSubtaskLifetime(Issue subtask, SprintHistoryData data) {
        DateTime creationTime = DateUtils.toDateTime(subtask.getCreated());
        HashSet<Long> addedIds = new HashSet<Long>();
        HashMap<Long, Object> forwardDatedChanges = new HashMap<Long, Object>();
        ArrayList<SprintHistoryEntry> newHistory = new ArrayList<SprintHistoryEntry>();
        for (SprintHistoryEntry change : data.getChanges()) {
            if (change.getDate().isBefore((ReadableInstant)creationTime)) {
                Object forwardDated;
                if (change.isAdded()) {
                    forwardDated = new SprintHistoryEntry(change.getSprintId(), creationTime, true);
                    forwardDatedChanges.put(((SprintHistoryEntry)forwardDated).getSprintId(), forwardDated);
                    addedIds.add(((SprintHistoryEntry)forwardDated).getSprintId());
                    newHistory.add((SprintHistoryEntry)forwardDated);
                    continue;
                }
                forwardDated = (SprintHistoryEntry)forwardDatedChanges.remove(change.getSprintId());
                if (forwardDated == null) continue;
                addedIds.remove(((SprintHistoryEntry)forwardDated).getSprintId());
                newHistory.remove(forwardDated);
                continue;
            }
            if (change.isAdded()) {
                addedIds.add(change.getSprintId());
            } else {
                addedIds.remove(change.getSprintId());
            }
            newHistory.add(change);
        }
        Collection<Sprint> newCurrentSprints = data.getCurrentSprints();
        HashSet<Long> allSprintIds = new HashSet<Long>();
        for (SprintHistoryEntry entry : newHistory) {
            allSprintIds.add(entry.getSprintId());
        }
        long[] newAllSprintIds = this.toLongArray(allSprintIds);
        return new SprintHistoryData(newCurrentSprints, newAllSprintIds, newHistory);
    }

    private SprintHistoryData getSprintChangeHistoryForIssue(Issue issue, CustomField sprintCustomField) {
        Collection currentSprints = Optional.ofNullable(sprintCustomField.getValue(issue)).orElse(Collections.emptyList());
        DateTime issueCreationTime = DateUtils.toDateTime(issue.getCreated());
        ArrayList<SprintHistoryEntry> allChanges = new ArrayList<SprintHistoryEntry>();
        HashSet<Long> allSprintIds = new HashSet<Long>();
        List changeItems = this.changeHistoryManager.getChangeItemsForField(issue, sprintCustomField.getName());
        changeItems.forEach(item -> this.addChanges((ChangeItemBean)item, (List<SprintHistoryEntry>)allChanges, (Set<Long>)allSprintIds, issueCreationTime));
        Set<Long> filteredSprintIds = this.removeOtherNonActiveSprints(changeItems, currentSprints, allSprintIds);
        for (Sprint sprint : currentSprints) {
            if (filteredSprintIds.contains(sprint.getId())) continue;
            SprintHistoryEntry entry = new SprintHistoryEntry((long)sprint.getId(), issueCreationTime, true);
            allChanges.add(0, entry);
            filteredSprintIds.add(entry.getSprintId());
        }
        return new SprintHistoryData(currentSprints, this.toLongArray(filteredSprintIds), allChanges);
    }

    private Set<Long> removeOtherNonActiveSprints(List<ChangeItemBean> changeItems, Collection<Sprint> currentSprints, Set<Long> allSprintIds) {
        Hashtable fetchedSprints = new Hashtable();
        currentSprints.forEach(s -> fetchedSprints.put(s.getId(), s));
        allSprintIds.stream().filter(sprintId -> !fetchedSprints.containsKey(sprintId)).map(sprintId -> this.sprintManager.getSprint((long)sprintId)).filter(Objects::nonNull).filter(ServiceOutcome::isValid).forEach(sprintServiceOutcome -> {
            Sprint cfr_ignored_0 = (Sprint)fetchedSprints.put(((Sprint)sprintServiceOutcome.get()).getId(), sprintServiceOutcome.get());
        });
        allSprintIds.removeIf(sprintId -> Optional.ofNullable(fetchedSprints.get(sprintId)).filter(sprint -> !currentSprints.contains(sprint)).map(sprint -> !this.movedToSprintAfterStartDate((Sprint)sprint, changeItems)).orElse(false));
        return allSprintIds;
    }

    private boolean movedToSprintAfterStartDate(Sprint sprint, List<ChangeItemBean> changeItems) {
        if (sprint.getStartDate() == null) {
            return false;
        }
        Long startMs = sprint.getStartDate().getMillis();
        Long completedMs = sprint.getCompleteDate() != null ? sprint.getCompleteDate().getMillis() : Long.MAX_VALUE;
        ChangeItemBean lastChangeBeforeSprint = null;
        for (ChangeItemBean changeItem : changeItems) {
            boolean inSprint;
            List<Long> changedTo = this.toIds(changeItem.getTo());
            Long changeMs = changeItem.getCreated().toInstant().toEpochMilli();
            boolean beforeSprint = changeMs < startMs;
            boolean bl = inSprint = changeMs >= startMs && changeMs < completedMs;
            if (beforeSprint && (lastChangeBeforeSprint == null || lastChangeBeforeSprint.getCreated().compareTo(changeItem.getCreated()) < 0)) {
                lastChangeBeforeSprint = changeItem;
                continue;
            }
            if (!inSprint || !changedTo.contains(sprint.getId())) continue;
            return true;
        }
        return lastChangeBeforeSprint != null && this.toIds(lastChangeBeforeSprint.getTo()).contains(sprint.getId());
    }

    private long[] toLongArray(Collection<Long> sprintIds) {
        long[] ids = new long[sprintIds.size()];
        int pos = 0;
        for (Long id : sprintIds) {
            ids[pos++] = id;
        }
        Arrays.sort(ids);
        return ids;
    }

    private void addChanges(ChangeItemBean bean, List<SprintHistoryEntry> changes, Set<Long> allSprintIds, DateTime issueCreationTime) {
        SprintHistoryEntry entry;
        DateTime date = DateUtils.toDateTime(bean.getCreated());
        List<Long> fromIds = this.toIds(bean.getFrom());
        List<Long> toIds = this.toIds(bean.getTo());
        List<Long> removed = this.inFirstButNotSecond(fromIds, toIds);
        List<Long> added = this.inFirstButNotSecond(toIds, fromIds);
        for (long removedId : removed) {
            if (!allSprintIds.contains(removedId)) {
                SprintHistoryEntry addedAtCreationTime = new SprintHistoryEntry(removedId, issueCreationTime, true);
                changes.add(0, addedAtCreationTime);
                allSprintIds.add(removedId);
            }
            entry = new SprintHistoryEntry(removedId, date, false);
            changes.add(entry);
        }
        for (long addedId : added) {
            entry = new SprintHistoryEntry(addedId, date, true);
            changes.add(entry);
            allSprintIds.add(addedId);
        }
    }

    private List<Long> inFirstButNotSecond(List<Long> first, List<Long> second) {
        HashSet<Long> secondSet = new HashSet<Long>(second);
        ArrayList<Long> result = new ArrayList<Long>(first);
        result.removeAll(secondSet);
        return result;
    }

    private List<Long> toIds(String value) {
        try {
            String[] strings = Optional.ofNullable(value).orElse("").split(",");
            return Arrays.stream(strings).map(s -> s.trim()).filter(s -> !s.equals("")).map(Long::parseLong).sorted().collect(Collectors.toList());
        }
        catch (NumberFormatException nfe) {
            log.debug("Unable to parse stored id", nfe);
            return Collections.emptyList();
        }
    }
}

