/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.sprint;

import com.atlassian.greenhopper.customfield.ReferencedEntityHistoryEntity;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;

public class SprintHistoryEntry
extends ReferencedEntityHistoryEntity {
    public SprintHistoryEntry(long sprintId, DateTime date, boolean added) {
        super(sprintId, date, added);
    }

    public static SprintHistoryEntry fromLuceneValue(String luceneValue) {
        String[] parts = luceneValue.split(";");
        if (parts.length != 3) {
            return null;
        }
        long sprintId = 0L;
        try {
            sprintId = Long.parseLong(parts[0]);
        }
        catch (NumberFormatException e) {
            return null;
        }
        DateTime date = null;
        try {
            date = ISODateTimeFormat.dateTime().parseDateTime(parts[1]);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        boolean added = parts[2].equals("a");
        return new SprintHistoryEntry(sprintId, date, added);
    }

    public long getSprintId() {
        return this.getReferencedEntityId();
    }
}

