/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.sprint;

import com.atlassian.greenhopper.customfield.searcher.GhOperatorSpecificQueryFactory;
import com.atlassian.greenhopper.customfield.sprint.SprintResolver;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class SprintEqualityQueryFactory
implements GhOperatorSpecificQueryFactory {
    private static final Logger log = Logger.getLogger(SprintEqualityQueryFactory.class);
    private final CustomField sprintCustomField;
    private final SprintResolver sprintResolver;

    public SprintEqualityQueryFactory(CustomField sprintCustomField, SprintResolver sprintResolver) {
        this.sprintCustomField = sprintCustomField;
        this.sprintResolver = sprintResolver;
    }

    @Override
    public QueryFactoryResult createQueryForSingleValue(QueryCreationContext queryCreationContext, String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator != Operator.EQUALS && operator != Operator.NOT_EQUALS) {
            log.warn((Object)String.format("Creating an equality query for a single value for field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s' and '%s'", fieldName, operator, Operator.EQUALS, Operator.NOT_EQUALS));
            return QueryFactoryResult.createFalseResult();
        }
        return this.createResult(queryCreationContext.getApplicationUser(), queryCreationContext.isSecurityOverriden(), operator, rawValues);
    }

    @Override
    public QueryFactoryResult createQueryForMultipleValues(QueryCreationContext queryCreationContext, String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator == Operator.IN || operator == Operator.NOT_IN) {
            return this.createResult(queryCreationContext.getApplicationUser(), queryCreationContext.isSecurityOverriden(), operator, rawValues);
        }
        log.warn((Object)String.format("Creating an equality query for multiple values for field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s' and '%s'", fieldName, operator, Operator.IN, Operator.NOT_IN));
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public QueryFactoryResult createQueryForEmptyOperand(QueryCreationContext queryCreationContext, String fieldName, Operator operator) {
        if (operator == Operator.IS || operator == Operator.EQUALS) {
            return new QueryFactoryResult(this.getIsEmptyQuery());
        }
        if (operator == Operator.IS_NOT || operator == Operator.NOT_EQUALS) {
            return new QueryFactoryResult(this.getIsNotEmptyQuery());
        }
        log.warn((Object)String.format("Creating an equality query for an empty value for field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s','%s', '%s' and '%s'", fieldName, operator, Operator.IS, Operator.EQUALS, Operator.IS_NOT, Operator.NOT_EQUALS));
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains(operator);
    }

    private QueryFactoryResult createResult(ApplicationUser user, boolean overrideSecurity, Operator operator, List<QueryLiteral> rawValues) {
        if (operator == Operator.IN || operator == Operator.EQUALS) {
            return this.handleIn(user, overrideSecurity, rawValues);
        }
        if (operator == Operator.NOT_IN || operator == Operator.NOT_EQUALS) {
            return this.handleNotIn(user, overrideSecurity, rawValues);
        }
        return QueryFactoryResult.createFalseResult();
    }

    private QueryFactoryResult handleIn(ApplicationUser user, boolean overrideSecurity, List<QueryLiteral> values) {
        BooleanQuery.Builder combined = new BooleanQuery.Builder();
        for (QueryLiteral rawValue : values) {
            combined.add(this.getQueryFromRawValue(user, overrideSecurity, rawValue), BooleanClause.Occur.SHOULD);
        }
        return new QueryFactoryResult((Query)combined.build());
    }

    private QueryFactoryResult handleNotIn(ApplicationUser user, boolean overrideSecurity, List<QueryLiteral> values) {
        ArrayList<Query> notQueries = new ArrayList<Query>();
        for (QueryLiteral rawValue : values) {
            if (rawValue.isEmpty()) continue;
            notQueries.add(this.getQueryFromRawValue(user, overrideSecurity, rawValue));
        }
        if (notQueries.isEmpty()) {
            return new QueryFactoryResult(this.getIsNotEmptyQuery());
        }
        BooleanQuery.Builder boolQuery = new BooleanQuery.Builder();
        boolQuery.add(this.getIsNotEmptyQuery(), BooleanClause.Occur.MUST);
        for (Query query : notQueries) {
            boolQuery.add(query, BooleanClause.Occur.MUST_NOT);
        }
        boolQuery.add(TermQueryFactoryPort.visibilityQuery(this.sprintCustomField.getId()), BooleanClause.Occur.MUST);
        return new QueryFactoryResult((Query)boolQuery.build(), false);
    }

    private Query getIsEmptyQuery() {
        QueryFactoryResult result = new QueryFactoryResult(TermQueryFactoryPort.nonEmptyQuery(this.sprintCustomField.getId()), true);
        return QueryFactoryResultPort.wrapWithVisibilityQuery(this.sprintCustomField.getId(), result).getLuceneQuery();
    }

    private Query getIsNotEmptyQuery() {
        return TermQueryFactoryPort.nonEmptyQuery(this.sprintCustomField.getId());
    }

    private Query getQueryFromRawValue(ApplicationUser user, boolean overrideSecurity, QueryLiteral rawValue) {
        if (rawValue.getLongValue() != null) {
            return new TermQuery(new Term(this.sprintCustomField.getId(), rawValue.getLongValue().toString()));
        }
        if (rawValue.getStringValue() != null) {
            BooleanQuery.Builder combined = new BooleanQuery.Builder();
            for (Long sprintId : this.sprintResolver.findSprintIdsByName(user, overrideSecurity, rawValue.getStringValue())) {
                combined.add((Query)new TermQuery(new Term(this.sprintCustomField.getId(), sprintId.toString())), BooleanClause.Occur.SHOULD);
            }
            return combined.build();
        }
        throw new IllegalStateException("Should not have gotten an empty query literal: " + rawValue);
    }

    private static class QueryFactoryResultPort {
        static final QueryFactoryResult FALSE_RESULT = new QueryFactoryResult((Query)new BooleanQuery.Builder().build(), false);

        private QueryFactoryResultPort() {
        }

        static QueryFactoryResult wrapWithVisibilityQuery(String fieldName, QueryFactoryResult result) {
            if (FALSE_RESULT.equals((Object)result)) {
                return result;
            }
            BooleanQuery.Builder finalQuery = new BooleanQuery.Builder();
            QueryFactoryResultPort.addToBooleanWithMust(result, finalQuery);
            finalQuery.add(TermQueryFactoryPort.visibilityQuery(fieldName), BooleanClause.Occur.MUST);
            return new QueryFactoryResult((Query)finalQuery.build());
        }

        static void addToBooleanWithMust(QueryFactoryResult result, BooleanQuery.Builder booleanQuery) {
            QueryFactoryResultPort.addToBooleanWithOccur(result, booleanQuery, BooleanClause.Occur.MUST);
        }

        static void addToBooleanWithOccur(QueryFactoryResult result, BooleanQuery.Builder booleanQuery, BooleanClause.Occur occur) {
            if (result.mustNotOccur()) {
                booleanQuery.add(result.getLuceneQuery(), BooleanClause.Occur.MUST_NOT);
            } else {
                booleanQuery.add(result.getLuceneQuery(), occur);
            }
        }
    }

    private static final class TermQueryFactoryPort {
        private TermQueryFactoryPort() {
        }

        static Query visibilityQuery(String fieldName) {
            return new TermQuery(new Term("visiblefieldids", fieldName));
        }

        static Query nonEmptyQuery(String fieldName) {
            return new TermQuery(new Term("nonemptyfieldids", fieldName));
        }
    }
}

