/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.sprint;

import com.atlassian.greenhopper.customfield.sprint.SprintHistoryData;
import com.atlassian.greenhopper.customfield.sprint.SprintHistoryEntry;
import com.atlassian.greenhopper.customfield.sprint.SprintHistoryEntryFactory;
import com.atlassian.greenhopper.service.BridgeServiceLocator;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public class SprintCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    protected SprintCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, customField);
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue);
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFieldsSearchable(doc, issue);
    }

    private void addDocumentFields(Document doc, Issue issue) {
        SprintHistoryEntryFactory sprintHistoryEntryFactory = BridgeServiceLocator.getInstance().getSprintHistoryEntryFactory();
        SprintHistoryData data = sprintHistoryEntryFactory.getSprintChangeHistory(issue, this.customField);
        Collection<Sprint> currentSprints = data.getCurrentSprints();
        if (!currentSprints.isEmpty()) {
            for (Sprint sprint : currentSprints) {
                String fieldId = this.getDocumentFieldId();
                String value = sprint.getId().toString();
                doc.add((IndexableField)new StringField(fieldId, value, Field.Store.YES));
                doc.add((IndexableField)new SortedSetDocValuesField(fieldId, new BytesRef((CharSequence)value)));
            }
        }
        String historyFieldId = SprintCustomFieldIndexer.getHistoryFieldId(this.customField);
        if (data.hasHistoricSprints()) {
            for (long sprintId : data.getAllIds()) {
                String value = Long.toString(sprintId);
                doc.add((IndexableField)new StringField(historyFieldId, value, Field.Store.YES));
                doc.add((IndexableField)new SortedSetDocValuesField(historyFieldId, new BytesRef((CharSequence)value)));
            }
        } else {
            doc.add((IndexableField)new StringField(historyFieldId, "-1", Field.Store.NO));
        }
        String string = SprintCustomFieldIndexer.getChangesFieldId(this.customField);
        for (SprintHistoryEntry entry : data.getChanges()) {
            doc.add((IndexableField)new StoredField(string, entry.toLuceneValue()));
        }
    }

    public static String getChangesFieldId(CustomField customField) {
        return customField.getId() + "_changes";
    }

    public static String getHistoryFieldId(CustomField customField) {
        return customField.getId() + "_history";
    }
}

