/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.sprint;

import com.atlassian.greenhopper.customfield.sprint.SprintIdEqual;
import com.atlassian.greenhopper.customfield.sprint.SprintNameContains;
import com.atlassian.greenhopper.customfield.sprint.SprintResolver;
import com.atlassian.greenhopper.service.BridgeServiceLocator;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class SprintClauseValueGenerator
implements ClauseValuesGenerator {
    private final JqlDateSupport jqlDateSupport;
    private final SprintResolver sprintResolver;

    public SprintClauseValueGenerator(JqlDateSupport jqlDateSupport, SprintResolver sprintResolver) {
        this.jqlDateSupport = jqlDateSupport;
        this.sprintResolver = sprintResolver;
    }

    public ClauseValuesGenerator.Results getPossibleValues(ApplicationUser searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        ServiceOutcome<Collection<Sprint>> allSprintsOutcome = this.getSprintManager().getAllSprints();
        if (allSprintsOutcome.isValid()) {
            Iterable<Sprint> filteredSprints = this.sprintResolver.findSprintByPredicate(searcher, false, this.buildSprintSuggestPredicate(valuePrefix), maxNumResults);
            ArrayList<ClauseValuesGenerator.Result> sprintValues = new ArrayList<ClauseValuesGenerator.Result>();
            for (Sprint sprint : filteredSprints) {
                String displayName = sprint.getStartDate() != null ? String.format("%s - %s (%d)", sprint.getName(), this.jqlDateSupport.getDateString(sprint.getStartDate().toDate()), sprint.getId()) : String.format("%s (%d)", sprint.getName(), sprint.getId());
                sprintValues.add(new ClauseValuesGenerator.Result(sprint.getId().toString(), displayName));
            }
            return new ClauseValuesGenerator.Results(sprintValues);
        }
        return new ClauseValuesGenerator.Results(Collections.emptyList());
    }

    private Predicate<Sprint> buildSprintSuggestPredicate(String valuePrefix) {
        SprintNameContains predicate;
        SprintNameContains sprintNameContainsPredicate = new SprintNameContains(valuePrefix);
        try {
            Long sprintIdCriteria = Long.valueOf(valuePrefix, 10);
            predicate = Predicates.or((Predicate)new SprintIdEqual(sprintIdCriteria), (Predicate)sprintNameContainsPredicate);
        }
        catch (NumberFormatException e) {
            predicate = sprintNameContainsPredicate;
        }
        return predicate;
    }

    private SprintManager getSprintManager() {
        return BridgeServiceLocator.getInstance().getSprintManager();
    }
}

