/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.sprint;

import com.atlassian.greenhopper.customfield.sprint.SprintResolver;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class SprintClauseValidator
implements ClauseValidator {
    private final JqlOperandResolver operandResolver;
    private final I18nHelper.BeanFactory i18nFactory;
    private final SprintResolver sprintResolver;
    private final SupportedOperatorsValidator supportedOperatorsValidator;

    public SprintClauseValidator(SprintResolver sprintResolver, JqlOperandResolver operandResolver, Set<Operator> supportedOperators, I18nHelper.BeanFactory i18nFactory) {
        this.operandResolver = operandResolver;
        this.sprintResolver = sprintResolver;
        this.i18nFactory = i18nFactory;
        this.supportedOperatorsValidator = new SupportedOperatorsValidator(new Collection[]{supportedOperators});
    }

    public MessageSet validate(final ApplicationUser searcher, TerminalClause terminalClause) {
        MessageSet errors = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        LazyReference<I18nHelper> i18nRef = new LazyReference<I18nHelper>(){

            @Override
            protected I18nHelper create() throws Exception {
                return SprintClauseValidator.this.i18nFactory.getInstance(searcher);
            }
        };
        List<QueryLiteral> rawValues = this.getRawValues(searcher, terminalClause);
        Operand queryOperand = terminalClause.getOperand();
        boolean performPermissionCheck = SprintClauseValidator.doesOperandNeedPermissionCheck(queryOperand);
        for (QueryLiteral rawValue : rawValues) {
            Collection<Long> sprintIdsByName;
            if (rawValue.getLongValue() != null) {
                if (!performPermissionCheck || this.sprintResolver.checkSprintAccessible(searcher, rawValue.getLongValue())) continue;
                errors.addErrorMessage(((I18nHelper)i18nRef.get()).getText("gh.sprint.searcher.validate.no.associated.sprint.with.this.id", rawValue.getLongValue().toString()));
                continue;
            }
            if (rawValue.getStringValue() == null || !(sprintIdsByName = this.sprintResolver.findSprintIdsByName(searcher, false, rawValue.getStringValue())).isEmpty()) continue;
            errors.addErrorMessage(((I18nHelper)i18nRef.get()).getText("gh.sprint.searcher.validate.no.associated.sprint.with.this.name", rawValue.getStringValue()));
        }
        return errors;
    }

    private List<QueryLiteral> getRawValues(ApplicationUser searcher, TerminalClause clause) {
        return this.operandResolver.getValues(searcher, clause.getOperand(), clause);
    }

    static boolean doesOperandNeedPermissionCheck(Operand operand) {
        boolean result = true;
        if (operand instanceof FunctionOperand) {
            String[] sanctionedFunctionNames;
            String queryOperandName = operand.getName();
            for (String name : sanctionedFunctionNames = new String[]{"openSprints", "closedSprints", "futureSprints"}) {
                result = result && !name.equalsIgnoreCase(queryOperandName);
            }
        } else if (operand instanceof MultiValueOperand) {
            MultiValueOperand multiValueOperand = (MultiValueOperand)operand;
            result = false;
            for (Operand inner : multiValueOperand.getValues()) {
                result = result || SprintClauseValidator.doesOperandNeedPermissionCheck(inner);
            }
        } else if (operand instanceof EmptyOperand) {
            result = false;
        }
        return result;
    }
}

