/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.sprint;

import com.atlassian.greenhopper.customfield.CustomFieldMetadata;
import com.atlassian.greenhopper.customfield.MetadataCFType;
import com.atlassian.greenhopper.customfield.sprint.PermissionUsedToModifySprintAnalyticEventPublisher;
import com.atlassian.greenhopper.customfield.sprint.SprintRestFieldOperationsHandler;
import com.atlassian.greenhopper.customfield.sprint.SprintRestSerializer;
import com.atlassian.greenhopper.features.AgileDarkFeature;
import com.atlassian.greenhopper.imports.SprintImportMapper;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.issue.IssueTypePrototype;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.service.sprint.SprintUtils;
import com.atlassian.greenhopper.web.util.WebUtilities;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypeImpl;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.config.Feature;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldValue;
import com.atlassian.jira.imports.project.customfield.ProjectCustomFieldImporter;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.CloneOptionConfiguration;
import com.atlassian.jira.issue.customfields.impl.AbstractMultiCFType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.export.FieldExportParts;
import com.atlassian.jira.issue.export.FieldExportPartsBuilder;
import com.atlassian.jira.issue.export.customfield.CustomFieldExportContext;
import com.atlassian.jira.issue.export.customfield.ExportableCustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.CustomFieldImpl;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.rest.FieldJsonRepresentation;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfo;
import com.atlassian.jira.issue.fields.rest.FieldTypeInfoContext;
import com.atlassian.jira.issue.fields.rest.RestAwareCustomFieldType;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.JsonType;
import com.atlassian.jira.issue.fields.rest.json.JsonTypeBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SprintCFType
extends AbstractMultiCFType<Sprint>
implements ExportableCustomFieldType,
MetadataCFType,
RestAwareCustomFieldType,
ProjectImportableCustomField,
RestCustomFieldTypeOperations {
    public static final CustomFieldMetadata CUSTOMFIELD_METADATA = CustomFieldMetadata.builder().setFieldName("gh.sprint.customfield.default.name").setFieldDescription("gh.sprint.customfield.desc").setFieldType("com.pyxis.greenhopper.jira:gh-sprint").setFieldSearcher("com.pyxis.greenhopper.jira:gh-sprint-searcher").setIssueTypePrototypes(IssueTypePrototype.ALL).setLockField(true).build();
    public static final JiraDataType SPRINT = new JiraDataTypeImpl(Sprint.class);
    private static final Comparator<Sprint> TYPE_COMPARATOR = new Comparator<Sprint>(){

        @Override
        public int compare(Sprint o1, Sprint o2) {
            return o1.getId().compareTo(o2.getId());
        }
    };
    public static final FieldTypeInfo DEFAULT_FIELD_TYPE_INFO = new FieldTypeInfo(null, null);
    private final SprintManager sprintManager;
    private final WebUtilities webUtilities;
    private final I18nFactoryService i18nFactory;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionService permissionService;
    private final SprintRestSerializer sprintRestSerializer;
    private final FeatureManager featureManager;
    private final IssueService issueService;
    private final PermissionUsedToModifySprintAnalyticEventPublisher permissionUsedToModifySprintAnalyticEventPublisher;
    private final SprintRestFieldOperationsHandler sprintRestFieldOperationsHandler;

    public SprintCFType(SprintManager sprintManager, WebUtilities webUtilities, CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, I18nFactoryService i18nFactory, JiraAuthenticationContext authenticationContext, PermissionService permissionService, SprintRestSerializer sprintRestSerializer, FeatureManager featureManager, IssueService issueService, PermissionUsedToModifySprintAnalyticEventPublisher permissionUsedToModifySprintAnalyticEventPublisher, SprintRestFieldOperationsHandler sprintRestFieldOperationsHandler) {
        super(customFieldValuePersister, genericConfigManager);
        this.sprintManager = sprintManager;
        this.webUtilities = webUtilities;
        this.i18nFactory = i18nFactory;
        this.authenticationContext = authenticationContext;
        this.permissionService = permissionService;
        this.sprintRestSerializer = sprintRestSerializer;
        this.sprintRestFieldOperationsHandler = sprintRestFieldOperationsHandler;
        this.featureManager = featureManager;
        this.issueService = issueService;
        this.permissionUsedToModifySprintAnalyticEventPublisher = permissionUsedToModifySprintAnalyticEventPublisher;
    }

    public Sprint getSingularObjectFromString(String idAsString) throws FieldValidationException {
        Long id;
        try {
            id = Long.valueOf(idAsString);
        }
        catch (NumberFormatException e) {
            throw new FieldValidationException(this.i18nFactory.getI18n(this.authenticationContext.getUser()).getText("gh.rapid.view.error.sprint.id.nan", (Object)idAsString));
        }
        ServiceOutcome<Sprint> outcome = this.sprintManager.getSprint(id);
        if (!outcome.isValid()) {
            throw new FieldValidationException(this.i18nFactory.getI18n(this.authenticationContext.getUser()).getText("gh.rapid.view.error.sprint.id.invalid", (Object)id.toString()));
        }
        return outcome.getValue();
    }

    public String getStringFromSingularObject(Sprint sprint) {
        if (sprint == null) {
            return null;
        }
        return sprint.getId().toString();
    }

    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        Object[] values = this.getParamsAsArray(relevantParams.getValuesForNullKey());
        if (values == null) {
            return;
        }
        for (Object value : values) {
            this.parseAndValidateParams(value, errorCollectionToAddTo, config);
        }
        if (!errorCollectionToAddTo.hasAnyErrors()) {
            this.fireSprintPermissionAnalyticEvent(values, relevantParams);
        }
    }

    private Object[] getParamsAsArray(Collection values) {
        for (Object value : values) {
            if (value instanceof String) {
                String ids = (String)value;
                Object[] parts = ids.split(",");
                return parts;
            }
            if (!(value instanceof Long)) continue;
            return values.toArray();
        }
        return Collections.emptyList().toArray();
    }

    @VisibleForTesting
    protected void parseAndValidateParams(Object idObj, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        Long id = null;
        if (idObj instanceof String) {
            String idAsString = (String)idObj;
            if (idAsString.isEmpty()) {
                return;
            }
            try {
                id = Long.valueOf(idAsString);
            }
            catch (NumberFormatException e) {
                errorCollectionToAddTo.addError(config.getFieldId(), this.i18nFactory.getI18n(this.authenticationContext.getUser()).getText("gh.rapid.view.error.sprint.id.nan", (Object)idAsString), ErrorCollection.Reason.VALIDATION_FAILED);
                return;
            }
        } else if (idObj instanceof Long) {
            id = (Long)idObj;
        }
        if (id != null && this.sprintManager.getSprint(id).isInvalid()) {
            errorCollectionToAddTo.addError(config.getFieldId(), this.i18nFactory.getI18n(this.authenticationContext.getUser()).getText("gh.rapid.view.error.sprint.id.invalid", (Object)id.toString()), ErrorCollection.Reason.NOT_FOUND);
        }
    }

    private void fireSprintPermissionAnalyticEvent(Object[] values, CustomFieldParams relevantParams) {
        List issueIds = (List)relevantParams.getKeysAndValues().get(CustomFieldImpl.getParamKeyIssueId());
        if (CollectionUtils.isEmpty((Collection)issueIds) || StringUtils.isBlank((CharSequence)((CharSequence)issueIds.get(0)))) {
            return;
        }
        IssueService.IssueResult issueResult = this.issueService.getIssue(this.authenticationContext.getLoggedInUser(), Long.valueOf((String)issueIds.get(0)));
        if (!issueResult.isValid()) {
            return;
        }
        MutableIssue issue = issueResult.getIssue();
        List<Sprint> sprints = this.getValueFromIssue(relevantParams.getCustomField(), (Issue)issue);
        this.permissionUsedToModifySprintAnalyticEventPublisher.publishEvent(values != null ? values : new Object[]{}, sprints != null ? sprints : Collections.emptyList(), relevantParams);
    }

    public Collection<Sprint> getValueFromCustomFieldParams(CustomFieldParams parameters) throws FieldValidationException {
        HashSet<Sprint> sprints = new HashSet<Sprint>();
        Collection values = parameters.getValuesForNullKey();
        if (values == null || values.isEmpty()) {
            return null;
        }
        for (Object value : values) {
            String ids = (String)value;
            String[] split = ids.split(",");
            if (ids.isEmpty()) continue;
            for (String id : split) {
                sprints.add(this.getSingularObjectFromString(id));
            }
        }
        return new ArrayList<Sprint>(sprints);
    }

    public Object getStringValueFromCustomFieldParams(CustomFieldParams parameters) {
        Collection groups = parameters.getValuesForNullKey();
        if (groups == null || groups.isEmpty()) {
            return null;
        }
        return groups;
    }

    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        HashMap params = Maps.newHashMap();
        params.put("hasEditPermission", issue != null && this.hasEditPermission(issue));
        params.put("util", this.webUtilities);
        params.put("emptyText", this.i18nFactory.getI18n(this.authenticationContext.getUser()).getText("gh.sprint.customfield.dropdown.empty"));
        return params;
    }

    public Map<String, Object> convertEditValueToObjects(Issue issue, CustomField field, @Nullable List<String> inputValues) {
        Object sprints;
        if (this.hasEditPermission(issue)) {
            ArrayList sprintObjects = Lists.newArrayList();
            if (inputValues != null) {
                Iterator<String> iterator = inputValues.iterator();
                while (iterator.hasNext()) {
                    String[] parts;
                    String string;
                    String ids = string = iterator.next();
                    for (String idAsString : parts = ids.split(",")) {
                        try {
                            sprintObjects.add(this.getSingularObjectFromString(idAsString));
                        }
                        catch (FieldValidationException fieldValidationException) {
                            // empty catch block
                        }
                    }
                }
            }
            sprints = ImmutableList.copyOf((Collection)sprintObjects);
        } else {
            Object sprintsFromIssue = this.getValueFromIssue(field, issue);
            sprints = sprintsFromIssue != null ? ImmutableList.copyOf((Collection)sprintsFromIssue) : Collections.emptyList();
        }
        ArrayList completedSprints = Lists.newArrayList();
        Sprint currentSprint = null;
        Iterator iterator = sprints.iterator();
        while (iterator.hasNext()) {
            Sprint sprint = (Sprint)iterator.next();
            if (sprint.isActive() || sprint.isFuture()) {
                currentSprint = sprint;
                continue;
            }
            completedSprints.add(sprint);
        }
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("sprints", sprints);
        hashMap.put("completedSprints", completedSprints);
        hashMap.put("currentSprint", currentSprint);
        return hashMap;
    }

    private boolean hasEditPermission(Issue issue) {
        if (issue.getKey() != null) {
            return this.permissionService.hasPermission(this.authenticationContext.getUser(), issue, 28);
        }
        if (issue.getProjectObject() != null) {
            return this.permissionService.hasPermission(this.authenticationContext.getUser(), issue.getProjectObject(), 28);
        }
        return false;
    }

    public Collection<Sprint> getValueFromIssue(CustomField field, Issue issue) {
        Issue parentIssue;
        if (issue.isSubTask() && (parentIssue = issue.getParentObject()) != null) {
            return super.getValueFromIssue(field, parentIssue);
        }
        return super.getValueFromIssue(field, issue);
    }

    public boolean isRenderable() {
        return false;
    }

    protected Comparator<Sprint> getTypeComparator() {
        return TYPE_COMPARATOR;
    }

    protected Object convertTypeToDbValue(@Nullable Sprint sprint) {
        return sprint.getId().toString();
    }

    protected Sprint convertDbValueToType(@Nullable Object dbValue) {
        Long id;
        try {
            id = Long.parseLong(dbValue.toString());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        ServiceOutcome<Sprint> outcome = this.sprintManager.getSprint(id);
        return outcome.isValid() ? outcome.getValue() : null;
    }

    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_LIMITED_TEXT;
    }

    public boolean valuesEqual(Collection<Sprint> v1, Collection<Sprint> v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        HashSet<Sprint> sprints1 = new HashSet<Sprint>(v1);
        HashSet<Sprint> sprints2 = new HashSet<Sprint>(v2);
        return sprints1.equals(sprints2);
    }

    public String getChangelogValue(CustomField field, Collection<Sprint> values) {
        if (values == null) {
            return "";
        }
        ArrayList<String> vs = new ArrayList<String>(values.size());
        ArrayList<Sprint> sortedValues = new ArrayList<Sprint>(values);
        Collections.sort(sortedValues, TYPE_COMPARATOR);
        for (Sprint sprint : sortedValues) {
            vs.add(this.getStringFromSingularObject(sprint));
        }
        return StringUtils.join(vs, (String)", ");
    }

    public String getChangelogString(CustomField field, Collection<Sprint> values) {
        if (values == null) {
            return "";
        }
        ArrayList<String> vs = new ArrayList<String>(values.size());
        ArrayList<Sprint> sortedValues = new ArrayList<Sprint>(values);
        Collections.sort(sortedValues, TYPE_COMPARATOR);
        for (Sprint sprint : sortedValues) {
            vs.add(sprint.getName());
        }
        return StringUtils.join(vs, (String)", ");
    }

    @Override
    public CustomFieldMetadata getMetadata() {
        return CUSTOMFIELD_METADATA;
    }

    public FieldTypeInfo getFieldTypeInfo(FieldTypeInfoContext fieldTypeInfoContext) {
        return DEFAULT_FIELD_TYPE_INFO;
    }

    public JsonType getJsonSchema(CustomField customField) {
        if (this.darkFeatureEnabled()) {
            return JsonTypeBuilder.customArray((String)"json", (String)this.getKey(), (Long)customField.getIdAsLong());
        }
        return this.getDefaultJsonSchema(customField, this.getKey());
    }

    public FieldJsonRepresentation getJsonFromIssue(CustomField field, Issue issue, boolean renderedVersionRequested, @Nullable FieldLayoutItem fieldLayoutItem) {
        Object sprints = this.getValueFromIssue(field, issue);
        if (sprints == null) {
            return new FieldJsonRepresentation(new JsonData(null));
        }
        if (this.darkFeatureEnabled()) {
            return new FieldJsonRepresentation(this.sprintRestSerializer.getJsonData(field, issue));
        }
        return this.getDefaultFieldJsonRepresentation((Collection<Sprint>)sprints);
    }

    private boolean darkFeatureEnabled() {
        return this.featureManager.isEnabled((Feature)AgileDarkFeature.REST_AWARE_SPRINT_FIELD);
    }

    private JsonType getDefaultJsonSchema(CustomField customField, String customFieldTypeKey) {
        return JsonTypeBuilder.customArray((String)"string", (String)customFieldTypeKey, (Long)customField.getIdAsLong());
    }

    private FieldJsonRepresentation getDefaultFieldJsonRepresentation(Collection<Sprint> sprints) {
        Collection sprintStrings = Collections2.transform(sprints, (Function)new Function<Sprint, String>(){

            public String apply(Sprint sprint) {
                return sprint.toString();
            }
        });
        return new FieldJsonRepresentation(new JsonData((Object)sprintStrings));
    }

    public ProjectCustomFieldImporter getProjectImporter() {
        return new SprintCustomFieldImporter();
    }

    public CloneOptionConfiguration getCloneOptionConfiguration(CustomField field, Issue issueToClone) {
        boolean shouldDisplayOption;
        boolean bl = shouldDisplayOption = !issueToClone.isSubTask() && field.hasValue(issueToClone);
        if (shouldDisplayOption) {
            String optionLabel = this.authenticationContext.getI18nHelper().getText("agile.clone.option.label.sprint", (Object)this.getValueFromIssue(field, issueToClone).size());
            return CloneOptionConfiguration.withOptionLabel((String)optionLabel);
        }
        return CloneOptionConfiguration.DO_NOT_DISPLAY;
    }

    public FieldExportParts getRepresentationFromIssue(Issue issue, CustomFieldExportContext context) {
        Optional<Object> sprints = Optional.ofNullable(this.getValueFromIssue(context.getCustomField(), issue));
        Stream sprintNames = sprints.map(Collection::stream).map(sprintStream -> sprintStream.sorted(SprintUtils.SPRINT_NATURAL_COMPARATOR).map(Sprint::getName)).orElse(Stream.empty());
        return FieldExportPartsBuilder.buildSinglePartRepresentation((String)context.getCustomField().getId(), (String)context.getI18nHelper().getText("gh.sprint"), sprintNames);
    }

    public RestFieldOperationsHandler getRestFieldOperation(CustomField field) {
        return this.sprintRestFieldOperationsHandler;
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx, CustomField field) {
        return null;
    }

    static class SprintCustomFieldImporter
    implements ProjectCustomFieldImporter {
        SprintCustomFieldImporter() {
        }

        public MessageSet canMapImportValue(ProjectImportMapper projectImportMapper, ExternalCustomFieldValue customFieldValue, FieldConfig fieldConfig, I18nHelper i18n) {
            return new MessageSetImpl();
        }

        public ProjectCustomFieldImporter.MappedCustomFieldValue getMappedImportValue(ProjectImportMapper projectImportMapper, ExternalCustomFieldValue customFieldValue, FieldConfig fieldConfig) {
            String mappedValue = null;
            SprintImportMapper sprintImportMapper = (SprintImportMapper)projectImportMapper.getNamedIdMapper("sprintMapper");
            String value = customFieldValue.getValue();
            if (value != null) {
                if (!sprintImportMapper.sprintsImported()) {
                    sprintImportMapper.linkSprintToIssue(customFieldValue.getIssueId(), value);
                } else {
                    mappedValue = sprintImportMapper.getMappedId(value);
                }
            }
            return new ProjectCustomFieldImporter.MappedCustomFieldValue(mappedValue);
        }
    }
}

