/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.sprint;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.greenhopper.analytics.AddRemoveIssueUsingManageSprintsPermissionAnalyticEvent;
import com.atlassian.greenhopper.analytics.AddRemoveIssueUsingSchedulePermissionAnalyticEvent;
import com.atlassian.greenhopper.analytics.EditSprintUsingManageSprintsPermissionAnalyticEvent;
import com.atlassian.greenhopper.analytics.EditSprintUsingSchedulePermissionAnalyticEvent;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.greenhopper.service.sprint.SprintPermissionService;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionUsedToModifySprintAnalyticEventPublisher {
    public static final String SPRINT_EDITING_CONTEXT_KEY = "analytic.editing.context";
    public static final String SPRINT_EDITED_IN_BOARD = "rapid-board";
    @Autowired
    private SprintManager sprintManager;
    @Autowired
    private SprintPermissionService sprintPermissionService;
    @Autowired
    private EventPublisher eventPublisher;
    @Autowired
    private JiraAuthenticationContext authenticationContext;

    public void publishEvent(@Nonnull Object[] sprintIdValuesToSave, @Nonnull Collection<Sprint> currentSprints, CustomFieldParams relevantParams) {
        Objects.requireNonNull(sprintIdValuesToSave, "sprintIdValuesToSave must not be null!");
        Objects.requireNonNull(currentSprints, "currentSprints must not be null!");
        Set<Sprint> sprintsToSave = this.convertToSprintByIds(PermissionUsedToModifySprintAnalyticEventPublisher.toSprintIds(sprintIdValuesToSave));
        List addedSprints = sprintsToSave.stream().filter(sprint -> !currentSprints.contains(sprint)).collect(Collectors.toList());
        List removedSprints = currentSprints.stream().filter(sprint -> Sprint.State.CLOSED != sprint.getState() && !sprintsToSave.contains(sprint)).collect(Collectors.toList());
        List sprintsToExamine = Stream.concat(removedSprints.stream(), addedSprints.stream()).collect(Collectors.toList());
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        Set usedPermissions = sprintsToExamine.stream().map(sprint -> this.sprintPermissionService.canUpdateSprint(user, (Sprint)sprint).isValid()).collect(Collectors.toSet());
        this.doFireSprintPermissionAnalyticEvent(usedPermissions.contains(Boolean.TRUE), usedPermissions.contains(Boolean.FALSE), (String)relevantParams.getFirstValueForKey(SPRINT_EDITING_CONTEXT_KEY));
    }

    private Set<Sprint> convertToSprintByIds(Set<Long> sprintIds) {
        return sprintIds.stream().map(sprintId -> this.sprintManager.getSprint((long)sprintId).getValue()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static Set<Long> toSprintIds(@Nonnull Object[] values) {
        if (values == null) {
            return Collections.emptySet();
        }
        return Stream.of(values).map(value -> {
            if (value instanceof String) {
                try {
                    return Long.valueOf((String)value);
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            if (value instanceof Long) {
                return (Long)value;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private void doFireSprintPermissionAnalyticEvent(boolean useManageSprintPermission, boolean useSchedulePermission, String editingContext) {
        if (useManageSprintPermission) {
            if (SPRINT_EDITED_IN_BOARD.equals(editingContext)) {
                this.eventPublisher.publish((Object)new AddRemoveIssueUsingManageSprintsPermissionAnalyticEvent());
            } else {
                this.eventPublisher.publish((Object)new EditSprintUsingManageSprintsPermissionAnalyticEvent());
            }
        }
        if (useSchedulePermission) {
            if (SPRINT_EDITED_IN_BOARD.equals(editingContext)) {
                this.eventPublisher.publish((Object)new AddRemoveIssueUsingSchedulePermissionAnalyticEvent());
            } else {
                this.eventPublisher.publish((Object)new EditSprintUsingSchedulePermissionAnalyticEvent());
            }
        }
    }
}

