/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.sprint;

import com.atlassian.greenhopper.customfield.sprint.SprintCFType;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintManager;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

public abstract class AbstractSprintsStateJqlFunction
extends AbstractJqlFunction {
    protected SprintManager sprintManager;

    public AbstractSprintsStateJqlFunction(SprintManager sprintManager) {
        this.sprintManager = sprintManager;
    }

    public MessageSet validate(ApplicationUser searcher, FunctionOperand operand, TerminalClause terminalClause) {
        return new MessageSetImpl();
    }

    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand operand, TerminalClause terminalClause) {
        ArrayList<QueryLiteral> literals = new ArrayList<QueryLiteral>();
        ServiceOutcome<Collection<Sprint>> sprintsOutcome = this.sprintManager.getSprints(EnumSet.of(this.getSprintState()));
        if (sprintsOutcome.isValid()) {
            for (Sprint sprint : sprintsOutcome.getValue()) {
                literals.add(new QueryLiteral((Operand)operand, sprint.getId()));
            }
        }
        return literals;
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 0;
    }

    public JiraDataType getDataType() {
        return SprintCFType.SPRINT;
    }

    protected abstract Sprint.State getSprintState();
}

