/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.searcher;

import com.atlassian.greenhopper.customfield.searcher.GhOperatorSpecificQueryFactory;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import java.util.Collection;
import java.util.List;

public class GhGenericClauseQueryFactory
implements ClauseQueryFactory {
    private final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private final JqlOperandResolver operandResolver;
    private final List<GhOperatorSpecificQueryFactory> operatorQueryFactories;
    private final String documentFieldName;

    public GhGenericClauseQueryFactory(String documentFieldName, List<GhOperatorSpecificQueryFactory> operatorQueryFactories, JqlOperandResolver operandResolver) {
        this.documentFieldName = (String)Assertions.notNull((String)"documentFieldName", (Object)documentFieldName);
        this.operandResolver = (JqlOperandResolver)Assertions.notNull((String)"operandResolver", (Object)operandResolver);
        this.operatorQueryFactories = CollectionUtil.copyAsImmutableList((Collection)((Collection)Assertions.notNull((String)"operatorQueryFactories", operatorQueryFactories)));
    }

    public QueryFactoryResult getQuery(QueryCreationContext queryCreationContext, TerminalClause terminalClause) {
        Operand operand = terminalClause.getOperand();
        Operator operator = terminalClause.getOperator();
        if (this.operandResolver.isValidOperand(operand)) {
            for (GhOperatorSpecificQueryFactory operatorQueryFactory : this.operatorQueryFactories) {
                if (!operatorQueryFactory.handlesOperator(operator)) continue;
                if (this.operandResolver.isEmptyOperand(operand)) {
                    return operatorQueryFactory.createQueryForEmptyOperand(queryCreationContext, this.documentFieldName, operator);
                }
                List<QueryLiteral> rawValues = this.getRawValues(queryCreationContext, terminalClause);
                if (this.operandResolver.isListOperand(operand)) {
                    return operatorQueryFactory.createQueryForMultipleValues(queryCreationContext, this.documentFieldName, operator, rawValues);
                }
                return operatorQueryFactory.createQueryForSingleValue(queryCreationContext, this.documentFieldName, operator, rawValues);
            }
            this.log.warn(String.format("The '%s' clause does not support the %s operator.", terminalClause.getName(), operator.getDisplayString()), new Object[0]);
            return QueryFactoryResult.createFalseResult();
        }
        this.log.warn(String.format("There is no OperandHandler registered to handle the operand '%s' for operand '%s'.", operator.getDisplayString(), terminalClause.getOperand().getDisplayString()), new Object[0]);
        return QueryFactoryResult.createFalseResult();
    }

    List<QueryLiteral> getRawValues(QueryCreationContext queryCreationContext, TerminalClause clause) {
        return this.operandResolver.getValues(queryCreationContext, clause.getOperand(), clause);
    }
}

