/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.rank;

import com.atlassian.greenhopper.customfield.rank.RankCustomFieldIndexer;
import com.atlassian.greenhopper.customfield.rank.RankLuceneFieldSorter;
import com.atlassian.greenhopper.service.BridgeServiceLocator;
import com.atlassian.greenhopper.service.rank.RankIndexService;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.SingleValueCustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.SortableCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.CustomFieldRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.searchers.transformer.ExactNumberCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.ActualValueCustomFieldClauseQueryFactory;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.util.IndexValueConverter;
import com.atlassian.jira.jql.util.NumberIndexValueConverter;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.NumberCustomFieldValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;

public class RankSearcher
extends AbstractInitializationCustomFieldSearcher
implements CustomFieldSearcher,
SortableCustomFieldSearcher {
    private final FieldVisibilityManager fieldVisibilityManager;
    private final JqlOperandResolver jqlOperandResolver;
    private final DoubleConverter doubleConverter;
    private final CustomFieldInputHelper customFieldInputHelper;
    private final I18nHelper.BeanFactory i18nFactory;
    private volatile CustomFieldSearcherInformation searcherInformation;
    private volatile SearchInputTransformer searchInputTransformer;
    private volatile SearchRenderer searchRenderer;
    private volatile CustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;

    public RankSearcher(FieldVisibilityManager fieldVisibilityManager, JqlOperandResolver jqlOperandResolver, DoubleConverter doubleConverter, CustomFieldInputHelper customFieldInputHelper, I18nHelper.BeanFactory i18nFactory) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.jqlOperandResolver = jqlOperandResolver;
        this.doubleConverter = doubleConverter;
        this.customFieldInputHelper = customFieldInputHelper;
        this.i18nFactory = i18nFactory;
    }

    public void init(CustomField field) {
        ClauseNames names = field.getClauseNames();
        NumberIndexValueConverter indexValueConverter = new NumberIndexValueConverter(this.doubleConverter);
        RankCustomFieldIndexer indexer = new RankCustomFieldIndexer(this.fieldVisibilityManager, field);
        SingleValueCustomFieldValueProvider customFieldValueProvider = new SingleValueCustomFieldValueProvider();
        this.searcherInformation = new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field));
        this.searchRenderer = new CustomFieldRenderer(names, this.getDescriptor(), field, (CustomFieldValueProvider)customFieldValueProvider, this.fieldVisibilityManager);
        this.searchInputTransformer = new ExactNumberCustomFieldSearchInputTransformer(field, names, this.searcherInformation.getId(), this.customFieldInputHelper);
        this.customFieldSearcherClauseHandler = new SimpleCustomFieldSearcherClauseHandler((ClauseValidator)new NumberCustomFieldValidator(this.jqlOperandResolver, indexValueConverter, this.i18nFactory), (ClauseQueryFactory)new ActualValueCustomFieldClauseQueryFactory(field.getId(), this.jqlOperandResolver, (IndexValueConverter)indexValueConverter, true), OperatorClasses.EMPTY_ONLY_OPERATORS, JiraDataTypes.NUMBER);
    }

    public SearcherInformation<CustomField> getSearchInformation() {
        if (this.searcherInformation == null) {
            throw new IllegalStateException("Attempt to retrieve SearcherInformation off uninitialised custom field searcher.");
        }
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        if (this.searchInputTransformer == null) {
            throw new IllegalStateException("Attempt to retrieve searchInputTransformer off uninitialised custom field searcher.");
        }
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        if (this.searchRenderer == null) {
            throw new IllegalStateException("Attempt to retrieve searchRenderer off uninitialised custom field searcher.");
        }
        return this.searchRenderer;
    }

    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        if (this.customFieldSearcherClauseHandler == null) {
            throw new IllegalStateException("Attempt to retrieve customFieldSearcherClauseHandler off uninitialised custom field searcher.");
        }
        return this.customFieldSearcherClauseHandler;
    }

    public LuceneFieldSorter getSorter(CustomField customField) {
        RankIndexService rankService = BridgeServiceLocator.getInstance().getRankIndexService();
        return new RankLuceneFieldSorter(rankService, customField);
    }
}

