/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.rank;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.service.rank.RankIndexService;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import java.util.Comparator;
import java.util.StringTokenizer;

public class RankLuceneFieldSorter
implements LuceneFieldSorter<long[]> {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private final Comparator<long[]> rankComparator;
    private final String documentConstant;
    private static final long[] EMPTY_ARRAY = new long[0];

    public RankLuceneFieldSorter(RankIndexService rankService, CustomField customField) {
        this.documentConstant = customField.getId();
        this.rankComparator = new RankComparator(rankService, customField.getIdAsLong());
    }

    public String getDocumentConstant() {
        return this.documentConstant;
    }

    public long[] getValueFromLuceneField(String value) {
        if (value == null) {
            return EMPTY_ARRAY;
        }
        try {
            StringTokenizer st = new StringTokenizer(value, ",");
            long[] result = new long[st.countTokens()];
            for (int x = 0; x < result.length; ++x) {
                result[x] = Long.valueOf(st.nextToken());
            }
            return result;
        }
        catch (RuntimeException e) {
            this.log.exception(e);
            return EMPTY_ARRAY;
        }
    }

    public Comparator<long[]> getComparator() {
        return this.rankComparator;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.documentConstant == null ? 0 : this.documentConstant.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RankLuceneFieldSorter other = (RankLuceneFieldSorter)obj;
        return !(this.documentConstant == null ? other.documentConstant != null : !this.documentConstant.equals(other.documentConstant));
    }

    private static class RankComparator
    implements Comparator<long[]> {
        private final RankIndexService rankIndexService;
        private final long customFieldId;

        public RankComparator(RankIndexService rankIndexService, Long customFieldId) {
            this.rankIndexService = rankIndexService;
            this.customFieldId = customFieldId;
        }

        @Override
        public int compare(long[] one, long[] other) {
            for (int x = 0; x < one.length && x < other.length; ++x) {
                int res = this.rankIndexService.compare(this.customFieldId, one[x], other[x]);
                if (res == 0) continue;
                return res;
            }
            return one.length - other.length;
        }
    }
}

