/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.rank;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public class RankCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    protected RankCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, customField);
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, true);
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, false);
    }

    private void addDocumentFields(Document doc, Issue issue, boolean searchable) {
        String value = String.valueOf(issue.getId());
        if (issue.getParentId() != null) {
            value = String.valueOf(issue.getParentId()) + "," + value;
        }
        if (value != null) {
            String documentFieldId = this.getDocumentFieldId();
            if (searchable) {
                doc.add((IndexableField)new StringField(documentFieldId, value, Field.Store.YES));
                doc.add((IndexableField)new SortedDocValuesField(documentFieldId, new BytesRef((CharSequence)value)));
            } else {
                doc.add((IndexableField)new StoredField(documentFieldId, value));
            }
        }
    }

    public boolean isFieldVisibleAndInScope(Issue issue) {
        return true;
    }

    protected boolean isRelevantForIssue(Issue issue) {
        return true;
    }
}

