/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.rank;

import com.atlassian.greenhopper.customfield.CustomFieldMetadata;
import com.atlassian.greenhopper.customfield.MetadataCFType;
import com.atlassian.greenhopper.service.issue.IssueTypePrototype;
import com.atlassian.greenhopper.service.rank.RankIndexService;
import com.atlassian.greenhopper.util.NumberUtils;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.impl.CalculatedCFType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.fields.CustomField;

public class RankCFType
extends CalculatedCFType
implements MetadataCFType,
SortableCustomField {
    public static final CustomFieldMetadata CUSTOMFIELD_METADATA = CustomFieldMetadata.builder().setFieldName("gh.rank.global.name").setFieldDescription("gh.rank.global.desc").setFieldType("com.pyxis.greenhopper.jira:gh-global-rank").setFieldSearcher("com.pyxis.greenhopper.jira:gh-global-rank-searcher").setIssueTypePrototypes(IssueTypePrototype.ALL).setLockField(true).build();
    private RankIndexService rankService;

    protected RankCFType(RankIndexService rankService) {
        this.rankService = rankService;
    }

    public Object getValueFromIssue(CustomField field, Issue issue) {
        Long issueId = issue.getId();
        return this.rankService.getIssuePosition(field.getIdAsLong(), issueId);
    }

    public String getStringFromSingularObject(Object singularObject) {
        return singularObject.toString();
    }

    public Object getSingularObjectFromString(String string) throws FieldValidationException {
        return NumberUtils.toLong(string);
    }

    @Override
    public CustomFieldMetadata getMetadata() {
        return CUSTOMFIELD_METADATA;
    }
}

