/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.lexorank;

import com.atlassian.greenhopper.customfield.AbstractCustomFieldSearcher;
import com.atlassian.greenhopper.customfield.lexorank.LexoRankClauseValidator;
import com.atlassian.greenhopper.customfield.lexorank.LexoRankIndexValueConverter;
import com.atlassian.greenhopper.customfield.lexorank.LexoRankIndexer;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.SingleValueCustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.SortableCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.CustomFieldRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.searchers.transformer.ExactTextCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.statistics.TextFieldSorter;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.ActualValueCustomFieldClauseQueryFactory;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.util.IndexValueConverter;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;

public class LexoRankSearcher
extends AbstractCustomFieldSearcher
implements CustomFieldSearcher,
SortableCustomFieldSearcher {
    private final FieldVisibilityManager fieldVisibilityManager;
    private final JqlOperandResolver jqlOperandResolver;
    private final CustomFieldInputHelper customFieldInputHelper;

    public LexoRankSearcher(FieldVisibilityManager fieldVisibilityManager, JqlOperandResolver jqlOperandResolver, CustomFieldInputHelper customFieldInputHelper) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.jqlOperandResolver = jqlOperandResolver;
        this.customFieldInputHelper = customFieldInputHelper;
    }

    public void init(CustomField field) {
        LexoRankIndexer indexer = new LexoRankIndexer(this.fieldVisibilityManager, field);
        SingleValueCustomFieldValueProvider customFieldValueProvider = new SingleValueCustomFieldValueProvider();
        this.setSearcherInformation(new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field)));
        ClauseNames names = field.getClauseNames();
        this.setSearchRenderer((SearchRenderer)new CustomFieldRenderer(names, this.getDescriptor(), field, (CustomFieldValueProvider)customFieldValueProvider, this.fieldVisibilityManager));
        this.setSearchInputTransformer((SearchInputTransformer)new ExactTextCustomFieldSearchInputTransformer(field, names, this.getSearchInformation().getId(), this.customFieldInputHelper));
        this.setCustomFieldSearcherClauseHandler((CustomFieldSearcherClauseHandler)new SimpleCustomFieldSearcherClauseHandler((ClauseValidator)new LexoRankClauseValidator(), (ClauseQueryFactory)new ActualValueCustomFieldClauseQueryFactory(field.getId(), this.jqlOperandResolver, (IndexValueConverter)new LexoRankIndexValueConverter(), true), OperatorClasses.EQUALITY_AND_RELATIONAL, JiraDataTypes.TEXT));
    }

    public LuceneFieldSorter getSorter(CustomField customField) {
        return new TextFieldSorter(customField.getId());
    }
}

