/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.lexorank;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.greenhopper.model.lexorank.LexoRankBucket;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public class LexoRankIndexer
extends AbstractCustomFieldIndexer {
    static final char LEXORANK_PARENT_CHILD_DELIMITER = '$';
    private final LoggerWrapper logger = LoggerWrapper.with(((Object)((Object)this)).getClass());

    protected LexoRankIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, customField);
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue);
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFieldsSearchable(doc, issue);
    }

    private void addDocumentFields(Document doc, Issue issue) {
        String fieldId = this.getDocumentFieldId();
        String indexValue = this.getIndexValue(issue);
        doc.add((IndexableField)new StringField(fieldId, indexValue, Field.Store.YES));
        doc.add((IndexableField)new SortedDocValuesField(fieldId, new BytesRef((CharSequence)indexValue)));
    }

    protected String getIndexValue(Issue issue) {
        StringBuilder indexField = new StringBuilder();
        Issue parentIssue = issue.getParentObject();
        if (parentIssue != null) {
            LexoRank parentLexoRank = this.getLexoRankValue(parentIssue);
            indexField.append(parentLexoRank.format());
            indexField.append('$');
        }
        LexoRank issueLexoRank = this.getLexoRankValue(issue);
        indexField.append(issueLexoRank.format());
        return indexField.toString();
    }

    private LexoRank getLexoRankValue(Issue issue) {
        LexoRank issueLexoRank = (LexoRank)this.customField.getValue(issue);
        if (issueLexoRank == null) {
            this.logger.warn("Could not retrieve LexoRank value for issue[id=%d]. Indexing max LexoRank value instead.", issue.getId());
            issueLexoRank = LexoRank.max(LexoRankBucket.max());
        }
        return issueLexoRank;
    }

    public boolean isFieldVisibleAndInScope(Issue issue) {
        return true;
    }

    protected boolean isRelevantForIssue(Issue issue) {
        return true;
    }
}

