/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.lexorank;

import com.atlassian.greenhopper.api.rank.RankChange;
import com.atlassian.greenhopper.customfield.CustomFieldMetadata;
import com.atlassian.greenhopper.customfield.CustomFieldService;
import com.atlassian.greenhopper.customfield.lexorank.LexoRankCFType;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.issue.fields.ManagedCustomFieldProvider;
import com.atlassian.greenhopper.manager.lexorank.LexoRankManager;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.lexorank.LexoRankChange;
import com.atlassian.greenhopper.service.properties.PropertyDao;
import com.atlassian.greenhopper.service.rank.SortedByRankFieldResult;
import com.atlassian.greenhopper.util.RequestBoundCacheFactory;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.util.DefaultIssueChangeHolder;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.query.Query;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.SearchSort;
import com.atlassian.query.order.SortOrder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LexoRankCustomFieldService
implements ManagedCustomFieldProvider {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    private static final String KEY_DEFAULT_LEXORANK_CUSTOMFIELD_ID = "GreenHopper.LexoRank.Default.customfield.id";
    private static final String VALIDATE_RANK_FIELD_CACHE_KEY = LexoRankCustomFieldService.class.getName() + ".validateRankField";
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private PropertyDao propertyDao;
    @Autowired
    private LexoRankManager lexoRankManager;
    @Autowired
    private CustomFieldManager customFieldManager;
    @Autowired
    private FieldManager fieldManager;
    @Autowired
    private IssueManager issueManager;
    @Autowired
    private IssueUpdater issueUpdater;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private RequestBoundCacheFactory requestBoundCacheFactory;

    public CustomField createLexoRankField() {
        return this.createLexoRankField(false);
    }

    private CustomField createLexoRankField(boolean locked) {
        CustomFieldMetadata metadata = CustomFieldMetadata.builder(LexoRankCFType.CUSTOMFIELD_METADATA).setLockField(locked).build();
        CustomField field = this.customFieldService.createCustomField(metadata);
        this.lexoRankManager.initField(field.getIdAsLong());
        return field;
    }

    private CustomField createDefaultLexoRankField() {
        CustomField field = this.createLexoRankField(true);
        this.propertyDao.setLongProperty(KEY_DEFAULT_LEXORANK_CUSTOMFIELD_ID, field.getIdAsLong());
        return field;
    }

    public synchronized CustomField getDefaultRankField() {
        Long id = this.propertyDao.getLongProperty(KEY_DEFAULT_LEXORANK_CUSTOMFIELD_ID);
        if (id != null) {
            CustomField rankField = this.customFieldService.getCustomField(id);
            if (rankField != null) {
                return rankField;
            }
            if (this.customFieldService.verifyCustomFieldExistsInDB(id)) {
                throw new RuntimeException(String.format("Custom field '%s' with ID '%d' exists in DB, but was not returned by the custom field service.", "Rank", id));
            }
        }
        return this.createDefaultLexoRankField();
    }

    public synchronized void deleteDefaultRankField() {
        CustomField rankField;
        Long id = this.propertyDao.getLongProperty(KEY_DEFAULT_LEXORANK_CUSTOMFIELD_ID);
        if (id != null && (rankField = this.customFieldService.getCustomField(id)) != null) {
            this.customFieldService.removeCustomField(rankField);
        }
        this.propertyDao.deleteProperty(KEY_DEFAULT_LEXORANK_CUSTOMFIELD_ID);
    }

    public boolean isRankField(long fieldId) {
        CustomField customField = this.customFieldManager.getCustomFieldObject(Long.valueOf(fieldId));
        if (customField == null) {
            return false;
        }
        return this.isRankField(customField);
    }

    public boolean isRankField(CustomField customField) {
        return this.isRankFieldType(customField);
    }

    public boolean isRankFieldType(CustomField customField) {
        return customField != null && customField.getCustomFieldType() instanceof LexoRankCFType;
    }

    public List<CustomField> getRankFields() {
        return this.customFieldService.getCustomFields(LexoRankCFType.class);
    }

    @Nonnull
    public ServiceOutcome<SortedByRankFieldResult> getSortedByRankField(Query query) {
        OrderBy orderByClause = query.getOrderByClause();
        if (orderByClause == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.rank.error.no.rank.field", new Object[0]);
        }
        List searchSorts = orderByClause.getSearchSorts();
        if (searchSorts.isEmpty()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.rank.error.no.rank.field", new Object[0]);
        }
        SearchSort searchSort = (SearchSort)searchSorts.get(0);
        return this.getRankFieldBySearchSort(searchSort);
    }

    @Nonnull
    public ServiceOutcome<CustomField> getValidatedCustomFieldSortedByRankField(ApplicationUser user, Query query) {
        ServiceOutcome<SortedByRankFieldResult> sortedByRankField = this.getSortedByRankField(query);
        if (!sortedByRankField.isValid()) {
            return ServiceOutcomeImpl.error(sortedByRankField);
        }
        SortedByRankFieldResult sortedByRankFieldResult = sortedByRankField.get();
        ServiceOutcome<Void> outcome = this.validateRankFieldConfiguration(user, sortedByRankFieldResult.getCustomField());
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        if (!sortedByRankFieldResult.isValid()) {
            return ServiceOutcomeImpl.from(sortedByRankFieldResult.getWarnings());
        }
        return ServiceOutcomeImpl.ok(sortedByRankFieldResult.getCustomField());
    }

    private ServiceOutcome<SortedByRankFieldResult> getRankFieldBySearchSort(SearchSort searchSort) {
        String fieldName = searchSort.getField();
        ServiceOutcome<SortedByRankFieldResult> result = this.getRankFieldByJqlFieldName(fieldName);
        if (!result.isValid()) {
            return result;
        }
        if (!result.getValue().isValid()) {
            return result;
        }
        SortOrder sortOrder = searchSort.getSortOrder();
        if (sortOrder == null || sortOrder.equals((Object)SortOrder.ASC)) {
            return result;
        }
        ErrorCollection warnings = new ErrorCollection();
        warnings.addError("gh.rank.global.jqlorderby.sort.order.descending", new Object[0]);
        return ServiceOutcomeImpl.ok(SortedByRankFieldResult.foundWithWarnings(result.getValue().getCustomField(), warnings, true));
    }

    private ServiceOutcome<SortedByRankFieldResult> getRankFieldByJqlFieldName(String fieldName) {
        JqlCustomFieldId id = JqlCustomFieldId.parseJqlCustomFieldId((String)fieldName);
        if (id != null) {
            CustomField customField = this.customFieldService.getCustomField(id.getId());
            if (customField != null && this.isRankCustomFieldType(customField)) {
                return ServiceOutcomeImpl.ok(SortedByRankFieldResult.valid(customField));
            }
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.rank.error.no.rank.field", new Object[0]);
        }
        Collection customFields = this.customFieldManager.getCustomFieldObjectsByName(fieldName);
        if (customFields == null || customFields.size() == 0) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.rank.error.no.rank.field", new Object[0]);
        }
        if (customFields.size() == 1) {
            CustomField customField = (CustomField)customFields.iterator().next();
            if (this.isRankCustomFieldType(customField)) {
                if (this.customFieldService.isSystemFieldName(fieldName)) {
                    this.log.error("The rank custom field with name %s and id %s shares a name with a system field. In order to use a rank custom field its name must be unique.", customField.getName(), customField.getId());
                    ErrorCollection warnings = new ErrorCollection();
                    warnings.addError("gh.rank.global.jqlorderby.systemfield.name.collision", customField.getName(), customField.getId());
                    return ServiceOutcomeImpl.ok(SortedByRankFieldResult.foundWithWarnings(customField, warnings, false));
                }
                return ServiceOutcomeImpl.ok(SortedByRankFieldResult.valid(customField));
            }
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.rank.error.no.rank.field", new Object[0]);
        }
        for (CustomField customField : customFields) {
            if (!this.isRankCustomFieldType(customField)) continue;
            this.log.error("The rank custom field with name %s and id %s shares a name with one or more other custom fields. In order to use a rank custom field its name must be unique.", customField.getName(), customField.getId());
            ErrorCollection warnings = new ErrorCollection();
            warnings.addError("gh.rank.global.jqlorderby.customfield.name.collision", customField.getName(), customField.getId());
            return ServiceOutcomeImpl.ok(SortedByRankFieldResult.foundWithWarnings(customField, warnings, true));
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rapid.rank.error.no.rank.field", new Object[0]);
    }

    public boolean isRankCustomFieldType(CustomField customField) {
        return customField != null && customField.getCustomFieldType() instanceof LexoRankCFType;
    }

    public ServiceOutcome<Void> validateRankFieldConfiguration(CustomField customField) {
        if (customField == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rank.global.error.missing", new Object[0]);
        }
        if (!(customField.getCustomFieldType() instanceof LexoRankCFType)) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rank.global.error.wrong.type", customField.getName(), customField.getId());
        }
        if (!customField.isGlobal()) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rank.global.error.not.global", customField.getName(), customField.getId());
        }
        return ServiceOutcomeImpl.ok();
    }

    public ServiceOutcome<Void> validateRankFieldConfiguration(ApplicationUser user, CustomField customField) {
        ValidateRankFieldKey cacheKey;
        Map cache = this.requestBoundCacheFactory.getCache(VALIDATE_RANK_FIELD_CACHE_KEY);
        ServiceOutcome<Void> resultOutcome = (ServiceOutcome<Void>)cache.get(cacheKey = new ValidateRankFieldKey(user, customField));
        if (resultOutcome == null) {
            resultOutcome = this.validateRankFieldConfiguration(customField);
            if (resultOutcome.isValid() && this.fieldManager.isFieldHidden(user, (Field)customField)) {
                resultOutcome = ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rank.global.error.hidden", customField.getName(), customField.getId());
            }
            cache.put(cacheKey, resultOutcome);
        }
        return resultOutcome;
    }

    public ServiceOutcome<Boolean> isFieldNameInQuerySafe(CustomField rankField) {
        if (rankField == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rank.global.error.missing", new Object[0]);
        }
        Collection customFields = this.customFieldManager.getCustomFieldObjectsByName(rankField.getName());
        if (customFields.size() == 0) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.rank.global.error.not.found", new Object[0]);
        }
        if (customFields.size() > 1) {
            return ServiceOutcomeImpl.ok(false);
        }
        return ServiceOutcomeImpl.ok(true);
    }

    public void addChangeItem(ApplicationUser user, RankChange change) {
        if (!(change instanceof LexoRankChange)) {
            throw new IllegalArgumentException("Unknown rank change instance: " + change.getClass());
        }
        LexoRankChange rankChange = (LexoRankChange)change;
        if (!rankChange.wasChanged()) {
            return;
        }
        MutableIssue issue = this.issueManager.getIssueObject(Long.valueOf(rankChange.getIssueId()));
        if (issue == null) {
            this.log.warn("Got a null issue for ID '%d' whilst trying to add a change item after ranking -- ignoring.", rankChange.getIssueId());
            return;
        }
        ChangeItemBean changeItemBean = this.createChangeItemBean(rankChange);
        DefaultIssueChangeHolder issueChangeHolder = new DefaultIssueChangeHolder();
        issueChangeHolder.addChangeItem(changeItemBean);
        boolean sendMail = false;
        EventDispatchOption dispatchOption = EventDispatchOption.ISSUE_UPDATED;
        IssueUpdateBean issueUpdateBean = new IssueUpdateBean((Issue)issue, (Issue)issue, dispatchOption.getEventTypeId(), user, sendMail, true);
        issueUpdateBean.setChangeItems((Collection)issueChangeHolder.getChangeItems());
        issueUpdateBean.setDispatchEvent(dispatchOption.isEventBeingSent());
        issueUpdateBean.setParams(MapBuilder.newBuilder((Object)"eventsource", (Object)"action").toMutableMap());
        this.issueUpdater.doUpdate(issueUpdateBean, false);
    }

    private ChangeItemBean createChangeItemBean(LexoRankChange rankChange) {
        CustomField rankField = this.customFieldService.getCustomField(rankChange.getCustomFieldId());
        String rankFieldName = rankField != null ? rankField.getNameKey() : "customfield_" + rankChange.getCustomFieldId();
        I18n2 i18n = this.i18nFactoryService.getI18n();
        String from = "";
        String fromString = "";
        String to = "";
        String toString = this.getPositionMessage(i18n, rankChange.getOldRank(), rankChange.getNewRank());
        return new ChangeItemBean("custom", rankFieldName, from, fromString, to, toString);
    }

    private String getPositionMessage(I18n2 i18n, LexoRank oldPosition, LexoRank newPosition) {
        int comp = oldPosition.compareTo(newPosition);
        if (comp < 0) {
            return i18n.getText("gh.rank.global.history.lower");
        }
        if (comp > 0) {
            return i18n.getText("gh.rank.global.history.higher");
        }
        return "";
    }

    @Override
    public Collection<CustomField> getManagedFields() {
        return Arrays.asList(this.getDefaultRankField());
    }

    protected static class ValidateRankFieldKey {
        private final String customFieldId;
        private final String userName;
        private final int hash;

        public ValidateRankFieldKey(@Nullable ApplicationUser user, @Nonnull CustomField customField) {
            this.customFieldId = customField.getId();
            this.userName = user != null ? user.getName() : null;
            this.hash = (user != null ? 31 * user.hashCode() : 0) + customField.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ValidateRankFieldKey)) {
                return false;
            }
            ValidateRankFieldKey that = (ValidateRankFieldKey)o;
            if (!this.customFieldId.equals(that.customFieldId)) {
                return false;
            }
            return !(this.userName != null ? !this.userName.equals(that.userName) : that.userName != null);
        }
    }
}

