/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.lexorank;

import com.atlassian.greenhopper.customfield.CustomFieldMetadata;
import com.atlassian.greenhopper.customfield.MetadataCFType;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.lexorank.LexoRankManager;
import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.issue.IssueTypePrototype;
import com.atlassian.greenhopper.service.lexorank.LexoRankChange;
import com.atlassian.greenhopper.service.lexorank.LexoRankOperationOutcome;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.SortableCustomField;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.util.ErrorCollection;
import com.opensymphony.util.TextUtils;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;

public class LexoRankCFType
extends AbstractCustomFieldType<LexoRank, LexoRank>
implements MetadataCFType,
SortableCustomField<LexoRank> {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    public static final CustomFieldMetadata CUSTOMFIELD_METADATA = CustomFieldMetadata.builder().setFieldName("gh.lexorank.field.name").setFieldDescription("gh.lexorank.field.desc").setFieldType("com.pyxis.greenhopper.jira:gh-lexo-rank").setFieldSearcher("com.pyxis.greenhopper.jira:gh-lexo-rank-searcher").setIssueTypePrototypes(IssueTypePrototype.ALL).setLockField(true).build();
    private final LexoRankManager lexoRankManager;

    public LexoRankCFType(LexoRankManager lexoRankManager) {
        this.lexoRankManager = lexoRankManager;
    }

    @Override
    public CustomFieldMetadata getMetadata() {
        return CUSTOMFIELD_METADATA;
    }

    public String getStringFromSingularObject(LexoRank lexoRank) {
        return lexoRank.format();
    }

    public LexoRank getSingularObjectFromString(String s) throws FieldValidationException {
        return LexoRank.parse(s);
    }

    public Set<Long> remove(CustomField customField) {
        ServiceOutcome<Set<Long>> dropOutcome = this.lexoRankManager.dropField(customField.getIdAsLong());
        if (dropOutcome.isInvalid()) {
            this.log.error("The following errors were encountered while removing custom field %d", customField.getIdAsLong());
            this.log.error(dropOutcome.getErrors());
            return Collections.emptySet();
        }
        return dropOutcome.getValue();
    }

    public void validateFromParams(CustomFieldParams customFieldParams, ErrorCollection errorCollection, FieldConfig fieldConfig) {
    }

    public void createValue(CustomField customField, Issue issue, LexoRank lexoRank) {
    }

    public void updateValue(CustomField customField, Issue issue, LexoRank lexoRank) {
    }

    public LexoRank getValueFromCustomFieldParams(CustomFieldParams customFieldParams) throws FieldValidationException {
        if (customFieldParams == null) {
            return null;
        }
        String valueStr = (String)customFieldParams.getFirstValueForNullKey();
        if (!TextUtils.stringSet((String)valueStr)) {
            return null;
        }
        return this.getSingularObjectFromString(valueStr);
    }

    public Object getStringValueFromCustomFieldParams(CustomFieldParams customFieldParams) {
        return customFieldParams.getFirstValueForNullKey();
    }

    public LexoRank getValueFromIssue(CustomField customField, Issue issue) {
        LexoRankOperationOutcome<LexoRankChange> rankOutcome = this.lexoRankManager.getRankOrRankInitially(customField.getIdAsLong(), issue.getId(), false);
        if (rankOutcome.isInvalid()) {
            this.log.warn("Unable to retrieve rank for field [%d] and issue [%d]", customField.getIdAsLong(), issue.getId());
            this.log.warn(rankOutcome.getErrors());
            return null;
        }
        LexoRankChange rankChange = rankOutcome.getResult();
        return rankChange.getNewRank();
    }

    public LexoRank getDefaultValue(FieldConfig fieldConfig) {
        return null;
    }

    public void setDefaultValue(FieldConfig fieldConfig, LexoRank lexoRank) {
    }

    public String getChangelogValue(CustomField customField, LexoRank lexoRank) {
        if (lexoRank == null) {
            return null;
        }
        return this.getStringFromSingularObject(lexoRank);
    }

    public int compare(@Nonnull LexoRank left, @Nonnull LexoRank right, FieldConfig fieldConfig) {
        return left.compareTo(right);
    }
}

