/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.lexorank;

import com.atlassian.event.api.EventListener;
import com.atlassian.greenhopper.customfield.lexorank.LexoRankCustomFieldService;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.manager.lexorank.LexoRankManager;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.jira.event.issue.field.CustomFieldCreatedEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LexoRankCFListener {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private LexoRankManager lexoRankManager;
    @Autowired
    private LexoRankCustomFieldService lexoRankCustomFieldService;

    @EventListener
    public void onCustomFieldCreated(CustomFieldCreatedEvent event) {
        Long fieldId = event.getId();
        if (!this.lexoRankCustomFieldService.isRankField(fieldId)) {
            return;
        }
        this.log.info("LexoRank field created with id %d, initing field values", fieldId);
        ServiceOutcome<Void> initOutcome = this.lexoRankManager.initField(fieldId);
        if (initOutcome.isInvalid()) {
            this.log.error("Unable to init ranking for field with id[%d]", fieldId);
            this.log.error(initOutcome.getErrors());
        }
    }
}

