/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiclink;

import com.atlassian.greenhopper.customfield.epiclink.EpicLinkCFType;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.statistics.AbstractCustomFieldStatisticsMapper;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestUtils;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Ordering;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

public class EpicLinkStatisticsMapper
extends AbstractCustomFieldStatisticsMapper
implements StatisticsMapper {
    private final CustomField epicLinkCustomField;
    private final IssueService issueService;
    private final ApplicationUser applicationUser;
    private final SearchService searchService;
    private final Collator collator;

    public EpicLinkStatisticsMapper(CustomField epicLinkCustomField, IssueService issueService, ApplicationUser applicationUser, SearchService searchService, Locale locale) {
        super(epicLinkCustomField);
        this.epicLinkCustomField = epicLinkCustomField;
        this.issueService = issueService;
        this.applicationUser = applicationUser;
        this.searchService = searchService;
        this.collator = Collator.getInstance(locale);
    }

    public String getDocumentConstant() {
        return this.epicLinkCustomField.getId();
    }

    public Issue getValueFromLuceneField(String documentValue) {
        if (documentValue == null) {
            return null;
        }
        try {
            return EpicLinkStatisticsMapper.nullSafeGetIssueFromResult(this.issueService.getIssue(this.applicationUser, Long.valueOf(documentValue)));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    protected String getSearchValue(Object value) {
        if (value == null) {
            return "";
        }
        return ((Issue)value).getKey();
    }

    public SearchRequest getSearchUrlSuffix(Object value, SearchRequest searchRequest) {
        if (value != null) {
            return super.getSearchUrlSuffix(value, searchRequest);
        }
        if (this.shouldShowEpicLinkSearcher(value, searchRequest)) {
            return this.addEmptyClauseToSearchRequest(searchRequest);
        }
        return null;
    }

    public Comparator<Issue> getComparator() {
        return this.getByNameOfLinkedEpicComparator().compound(this.getByIdOfLinkedEpicComparator());
    }

    public boolean equals(Object o) {
        if (o instanceof EpicLinkStatisticsMapper) {
            EpicLinkStatisticsMapper that = (EpicLinkStatisticsMapper)((Object)o);
            return Objects.equal((Object)this.epicLinkCustomField, (Object)that.epicLinkCustomField) && Objects.equal((Object)this.issueService, (Object)that.issueService) && Objects.equal((Object)this.searchService, (Object)that.searchService) && Objects.equal((Object)this.applicationUser, (Object)that.applicationUser) && Objects.equal((Object)this.collator, (Object)that.collator);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.epicLinkCustomField, this.issueService, this.searchService, this.applicationUser, this.collator});
    }

    private boolean shouldShowEpicLinkSearcher(Object value, SearchRequest searchRequest) {
        SearchContext searchRequestContext = this.searchService.getSearchContext(this.applicationUser, searchRequest.getQuery());
        SearchContext possibleContext = this.getSearchContextFromValue(value);
        SearchContext combinedSearchContext = SearchRequestUtils.getCombinedSearchContext((SearchContext)searchRequestContext, (SearchContext)possibleContext);
        CustomFieldSearcher searcher = this.customField.getCustomFieldSearcher();
        return searcher.getSearchRenderer().isShown(this.applicationUser, combinedSearchContext);
    }

    private SearchRequest addEmptyClauseToSearchRequest(SearchRequest searchRequest) {
        JqlClauseBuilder whereClauseBuilder = JqlQueryBuilder.newClauseBuilder((Query)searchRequest.getQuery()).defaultAnd();
        whereClauseBuilder.addEmptyCondition(this.customField.getFieldName());
        return new SearchRequest(whereClauseBuilder.buildQuery());
    }

    private static Issue nullSafeGetIssueFromResult(IssueService.IssueResult issueResult) {
        if (issueResult != null && issueResult.isValid()) {
            return issueResult.getIssue();
        }
        return null;
    }

    private String getNameOfLinkedEpic(Issue issue) {
        if (issue == null) {
            return null;
        }
        return ((EpicLinkCFType)this.epicLinkCustomField.getCustomFieldType()).getEpicDisplayName(issue);
    }

    private Ordering<Issue> getByNameOfLinkedEpicComparator() {
        return Ordering.from((Comparator)this.collator).nullsLast().onResultOf((Function)new Function<Issue, String>(){

            public String apply(Issue input) {
                return EpicLinkStatisticsMapper.this.getNameOfLinkedEpic(input);
            }
        });
    }

    private Ordering<Issue> getByIdOfLinkedEpicComparator() {
        return Ordering.natural().nullsLast().onResultOf((Function)new Function<Issue, Long>(){

            public Long apply(Issue input) {
                if (input == null) {
                    return null;
                }
                return input.getId();
            }
        });
    }
}

