/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiclink;

import com.atlassian.greenhopper.customfield.AbstractCustomFieldSearcher;
import com.atlassian.greenhopper.customfield.epiclink.EpicLinkClauseQueryFactory;
import com.atlassian.greenhopper.customfield.epiclink.EpicLinkClauseValidator;
import com.atlassian.greenhopper.customfield.epiclink.EpicLinkClauseValueGenerator;
import com.atlassian.greenhopper.customfield.epiclink.EpicLinkCustomFieldIndexer;
import com.atlassian.greenhopper.customfield.epiclink.EpicLinkResolver;
import com.atlassian.greenhopper.customfield.epiclink.EpicLinkSearchInputTransformer;
import com.atlassian.greenhopper.customfield.epiclink.EpicLinkSearchRenderer;
import com.atlassian.greenhopper.customfield.epiclink.EpicLinkStatisticsMapper;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.SortableCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldContextValueGeneratingClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldStattable;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.SimpleClauseContextFactory;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;

public class EpicLinkSearcher
extends AbstractCustomFieldSearcher
implements CustomFieldSearcher,
SortableCustomFieldSearcher,
CustomFieldStattable {
    private final JqlOperandResolver jqlOperandResolver;
    private final CustomFieldInputHelper customFieldInputHelper;
    private final ChangeHistoryManager changeHistoryManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final IssueService issueService;
    private final SearchService searchService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ApplicationProperties applicationProperties;
    private VelocityTemplatingEngine velocityTemplateEngine;
    private FieldVisibilityManager fieldVisibilityManager;

    public EpicLinkSearcher(JqlOperandResolver jqlOperandResolver, CustomFieldInputHelper customFieldInputHelper, ChangeHistoryManager changeHistoryManager, I18nHelper.BeanFactory i18nFactory, JiraAuthenticationContext jiraAuthenticationContext, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, FieldVisibilityManager fieldVisibilityManager, SearchService searchService, IssueService issueService) {
        this.jqlOperandResolver = jqlOperandResolver;
        this.customFieldInputHelper = customFieldInputHelper;
        this.changeHistoryManager = changeHistoryManager;
        this.i18nFactory = i18nFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.searchService = searchService;
        this.issueService = issueService;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.applicationProperties = applicationProperties;
    }

    public void init(CustomField field) {
        ClauseNames names = field.getClauseNames();
        EpicLinkCustomFieldIndexer indexer = new EpicLinkCustomFieldIndexer(field, this.changeHistoryManager);
        this.setSearcherInformation(new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field)));
        this.velocityTemplateEngine = (VelocityTemplatingEngine)ComponentAccessor.getOSGiComponentInstanceOfType(VelocityTemplatingEngine.class);
        this.setSearchRenderer(new EpicLinkSearchRenderer(this.velocityRequestContextFactory, this.applicationProperties, this.velocityTemplateEngine, field, this.fieldVisibilityManager, this.i18nFactory));
        this.setSearchInputTransformer(new EpicLinkSearchInputTransformer(field, names, this.getSearchInformation().getId(), this.customFieldInputHelper, this.jqlOperandResolver));
        EpicLinkResolver epicLinkResolver = new EpicLinkResolver(field);
        this.setCustomFieldSearcherClauseHandler((CustomFieldSearcherClauseHandler)new SimpleCustomFieldContextValueGeneratingClauseHandler((ClauseValidator)new EpicLinkClauseValidator(this.jqlOperandResolver, epicLinkResolver, this.i18nFactory), (ClauseQueryFactory)new EpicLinkClauseQueryFactory(this.jqlOperandResolver, field, epicLinkResolver), (ClauseContextFactory)new SimpleClauseContextFactory(), (ClauseValuesGenerator)new EpicLinkClauseValueGenerator(), OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, JiraDataTypes.ISSUE));
    }

    public StatisticsMapper getStatisticsMapper(CustomField customField) {
        return this.createEpicLinkStatisticsMapper(customField);
    }

    public LuceneFieldSorter getSorter(CustomField customField) {
        return this.createEpicLinkStatisticsMapper(customField);
    }

    private EpicLinkStatisticsMapper createEpicLinkStatisticsMapper(CustomField customField) {
        return new EpicLinkStatisticsMapper(customField, this.issueService, this.jiraAuthenticationContext.getUser(), this.searchService, this.jiraAuthenticationContext.getLocale());
    }
}

