/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiclink;

import com.atlassian.greenhopper.customfield.epiclink.EpicLinkCFType;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import webwork.action.Action;

public class EpicLinkSearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    private final CustomField customField;
    private final FieldVisibilityManager fieldVisibilityManager;
    private static final String EPIC_LINKS_PARAM = "epicLinks";
    private static final String EPIC_LINKS_AS_STRING_PARAM = "epicLinksAsString";
    private final I18nHelper.BeanFactory i18nFactory;

    public EpicLinkSearchRenderer(VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityTemplatingEngine templatingEngine, CustomField customField, FieldVisibilityManager fieldVisibilityManager, I18nHelper.BeanFactory i18nFactory) {
        super(velocityRequestContextFactory, applicationProperties, templatingEngine, customField.getId(), "navigator.filter." + customField.getId());
        this.customField = customField;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.i18nFactory = i18nFactory;
    }

    public String getEditHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map<String, Object> velocityParams = this.prepareEssentialVelocityParams(user, searchContext, fieldValuesHolder, displayParameters, action);
        return this.renderEditTemplate("epic-link-searcher-edit.vm", velocityParams);
    }

    public boolean isShown(ApplicationUser user, SearchContext searchContext) {
        return this.customField.isInScope(searchContext) && !this.fieldVisibilityManager.isFieldHidden(user, this.customField.getId());
    }

    public String getViewHtml(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map<String, Object> velocityParams = this.prepareEssentialVelocityParams(user, searchContext, fieldValuesHolder, displayParameters, action);
        velocityParams.put(EPIC_LINKS_AS_STRING_PARAM, EpicLinkSearchRenderer.listToString((List)velocityParams.get(EPIC_LINKS_PARAM)));
        return this.renderViewTemplate("epic-link-searcher-view.vm", velocityParams);
    }

    public boolean isRelevantForQuery(ApplicationUser user, Query query) {
        return this.isRelevantForQuery(this.customField.getClauseNames(), query);
    }

    private Map<String, Object> prepareEssentialVelocityParams(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map<?, ?> displayParameters, Action action) {
        Map velocityParams = this.getVelocityParams(user, searchContext, null, fieldValuesHolder, displayParameters, action);
        List<EpicLinkMultiselectModel> listOfEpicNames = EpicLinkSearchRenderer.transformSelectedEpicLinksToMultiSelectModel(this.customField, this.getCustomFieldParams(fieldValuesHolder), this.i18nFactory.getInstance(user));
        velocityParams.put(EPIC_LINKS_PARAM, listOfEpicNames);
        return velocityParams;
    }

    private CustomFieldParams getCustomFieldParams(FieldValuesHolder fieldValuesHolder) {
        return (CustomFieldParams)fieldValuesHolder.get((Object)this.customField.getId());
    }

    private static List<EpicLinkMultiselectModel> transformSelectedEpicLinksToMultiSelectModel(final CustomField epicLinkCustomField, CustomFieldParams customFieldParams, final I18nHelper i18nHelper) {
        if (customFieldParams == null) {
            return Lists.newArrayList();
        }
        return Lists.transform((List)Lists.newArrayList((Iterable)customFieldParams.getAllValues()), (Function)new Function<String, EpicLinkMultiselectModel>(){

            public EpicLinkMultiselectModel apply(String keyOfLinkedEpic) {
                return new EpicLinkMultiselectModel(keyOfLinkedEpic, EpicLinkSearchRenderer.getDisplayNameOfGivenEpic(epicLinkCustomField, keyOfLinkedEpic, i18nHelper));
            }
        });
    }

    private static String getDisplayNameOfGivenEpic(CustomField epicLinkCustomField, String epicKey, I18nHelper i18nHelper) {
        if ("EMPTY".equals(epicKey)) {
            return i18nHelper.getText("gh.epic.link.searcher.special.option");
        }
        return ((EpicLinkCFType)epicLinkCustomField.getCustomFieldType()).getEpicDisplayName(epicKey);
    }

    private static String listToString(List<EpicLinkMultiselectModel> epicLinkMultiselectModels) {
        String result = "";
        for (EpicLinkMultiselectModel model : epicLinkMultiselectModels) {
            result = result + model.toString() + ",";
        }
        return StringUtils.removeEnd((String)result, (String)",");
    }

    public static class EpicLinkMultiselectModel {
        private String keyOfLinkedEpic;
        private String nameOfLinkedEpic;

        private EpicLinkMultiselectModel(String keyOfLinkedEpic, String nameOfLinkedEpic) {
            this.keyOfLinkedEpic = keyOfLinkedEpic;
            this.nameOfLinkedEpic = nameOfLinkedEpic;
        }

        public String getKeyOfLinkedEpic() {
            return this.keyOfLinkedEpic;
        }

        public void setKeyOfLinkedEpic(String keyOfLinkedEpic) {
            this.keyOfLinkedEpic = keyOfLinkedEpic;
        }

        public String getNameOfLinkedEpic() {
            return this.nameOfLinkedEpic;
        }

        public void setNameOfLinkedEpic(String nameOfLinkedEpic) {
            this.nameOfLinkedEpic = nameOfLinkedEpic;
        }

        public String toString() {
            return this.getNameOfLinkedEpic();
        }

        public boolean isNoEpicLink() {
            return "EMPTY".equals(this.keyOfLinkedEpic);
        }
    }
}

