/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiclink;

import com.atlassian.jira.issue.customfields.searchers.transformer.AbstractCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.impl.NamedTerminalClauseCollectingVisitor;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import com.atlassian.query.operator.Operator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class EpicLinkSearchInputTransformer
extends AbstractCustomFieldSearchInputTransformer
implements SearchInputTransformer {
    private final ClauseNames clauseNames;
    private final String urlParameterName;
    private final JqlOperandResolver jqlOperandResolver;
    private static final String TERMINAL_CLAUSE_NAME = "Epic Link";

    public EpicLinkSearchInputTransformer(CustomField field, ClauseNames clauseNames, String urlParameterName, CustomFieldInputHelper customFieldInputHelper, JqlOperandResolver jqlOperandResolver) {
        super(field, urlParameterName, customFieldInputHelper);
        this.clauseNames = clauseNames;
        this.urlParameterName = urlParameterName;
        this.jqlOperandResolver = jqlOperandResolver;
    }

    public boolean doRelevantClausesFitFilterForm(ApplicationUser searcher, Query query, SearchContext searchContext) {
        if (query != null && query.getWhereClause() != null) {
            SimpleNavigatorCollectorVisitor collectorVisitor = new SimpleNavigatorCollectorVisitor(this.clauseNames.getJqlFieldNames());
            query.getWhereClause().accept((ClauseVisitor)collectorVisitor);
            return collectorVisitor.getClauses().size() == 1;
        }
        return true;
    }

    protected Clause getClauseFromParams(ApplicationUser user, CustomFieldParams customFieldParams) {
        Collection searchValues = customFieldParams.getValuesForNullKey();
        if (CollectionUtils.isNotEmpty((Collection)searchValues)) {
            List<Operand> operands = this.computeOperandsFromSearchValues(searchValues);
            if (operands.size() == 1) {
                return new TerminalClauseImpl(this.getClauseName(user, this.clauseNames), Operator.EQUALS, operands.get(0));
            }
            if (operands.size() > 1) {
                return new TerminalClauseImpl(this.getClauseName(user, this.clauseNames), Operator.IN, (Operand)new MultiValueOperand(operands));
            }
        }
        return null;
    }

    @VisibleForTesting
    List<Operand> computeOperandsFromSearchValues(Collection<Object> searchValues) {
        return searchValues.stream().filter(obj -> obj instanceof String).filter(obj -> !obj.equals("-1")).map(this::toOperand).collect(Collectors.toList());
    }

    private Operand toOperand(Object value) {
        return "EMPTY".equals(value) ? EmptyOperand.EMPTY : new SingleValueOperand((String)value);
    }

    protected CustomFieldParams getParamsFromSearchRequest(ApplicationUser user, Query query, SearchContext searchContext) {
        HashSet<String> allValues = new HashSet<String>();
        List<TerminalClause> clauses = this.getMatchingClauses(query);
        for (TerminalClause clause : clauses) {
            allValues.addAll(this.getAllNavigatorValues(user, clause.getOperand(), clause));
        }
        return new CustomFieldParamsImpl(this.getCustomField(), allValues);
    }

    public void validateParams(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
        if (fieldValuesHolder != null && fieldValuesHolder.containsKey((Object)this.urlParameterName)) {
            CustomFieldParams customFieldParams = (CustomFieldParams)fieldValuesHolder.get((Object)this.urlParameterName);
            ArrayList keyOfLinkedEpicsInRelevantParams = Lists.newArrayList((Iterable)customFieldParams.getValuesForNullKey());
            String emptyJqlOperandInParams = this.getEmptyJqlOperandInParams(keyOfLinkedEpicsInRelevantParams);
            if (emptyJqlOperandInParams != null) {
                this.validateParamsWithoutEmptyOperand(user, searchContext, fieldValuesHolder, i18nHelper, errors, customFieldParams, keyOfLinkedEpicsInRelevantParams, emptyJqlOperandInParams);
            } else {
                super.validateParams(user, searchContext, fieldValuesHolder, i18nHelper, errors);
            }
        }
    }

    private void validateParamsWithoutEmptyOperand(ApplicationUser user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors, CustomFieldParams customFieldParams, List<String> keyOfLinkedEpicInRelevantParams, String emptyJqlOperandInParams) {
        keyOfLinkedEpicInRelevantParams.remove(emptyJqlOperandInParams);
        customFieldParams.put(null, (Collection)Lists.newArrayList(keyOfLinkedEpicInRelevantParams));
        super.validateParams(user, searchContext, fieldValuesHolder, i18nHelper, errors);
        keyOfLinkedEpicInRelevantParams.add(emptyJqlOperandInParams);
        customFieldParams.put(null, (Collection)Lists.newArrayList(keyOfLinkedEpicInRelevantParams));
    }

    private String getEmptyJqlOperandInParams(List<String> keyOfLinkedEpicInRelevantParams) {
        for (String keyOfLinkedEpic : keyOfLinkedEpicInRelevantParams) {
            if (!"EMPTY".equals(keyOfLinkedEpic)) continue;
            return keyOfLinkedEpic;
        }
        return null;
    }

    private List<TerminalClause> getMatchingClauses(Query query) {
        NamedTerminalClauseCollectingVisitor collectorVisitor = new NamedTerminalClauseCollectingVisitor(TERMINAL_CLAUSE_NAME);
        if (query != null && query.getWhereClause() != null) {
            query.getWhereClause().accept((ClauseVisitor)collectorVisitor);
            return collectorVisitor.getNamedClauses();
        }
        return Collections.EMPTY_LIST;
    }

    private List<String> getAllNavigatorValues(ApplicationUser user, Operand operand, TerminalClause clause) {
        List queryLiterals = this.jqlOperandResolver.getValues(user, operand, clause);
        return Lists.transform((List)queryLiterals, (Function)new Function<QueryLiteral, String>(){

            public String apply(QueryLiteral queryLiteral) {
                if (EpicLinkSearchInputTransformer.this.jqlOperandResolver.isEmptyOperand(queryLiteral.getSourceOperand())) {
                    return "EMPTY";
                }
                return queryLiteral.getStringValue();
            }
        });
    }
}

