/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiclink;

import com.atlassian.greenhopper.customfield.RestFieldSetOperationsHelper;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.ServiceResultImpl;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.rest.FieldOperationHolder;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.base.Function;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EpicLinkRestFieldOperationsHandler
implements RestFieldOperationsHandler {
    private final IssueTypeService issueTypeService;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final IssueService issueService;
    private final RestFieldSetOperationsHelper restFieldSetOperationsHelper;

    @Autowired
    public EpicLinkRestFieldOperationsHandler(IssueTypeService issueTypeService, JiraAuthenticationContext jiraAuthenticationContext, IssueService issueService, RestFieldSetOperationsHelper restFieldSetOperationsHelper) {
        this.issueTypeService = issueTypeService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.issueService = issueService;
        this.restFieldSetOperationsHelper = restFieldSetOperationsHelper;
    }

    public Set<String> getSupportedOperations() {
        return this.restFieldSetOperationsHelper.getSetOperation();
    }

    public ErrorCollection updateIssueInputParameters(IssueContext issueCtx, @Nullable Issue issue, String fieldId, IssueInputParameters inputParameters, List<FieldOperationHolder> operations) {
        return this.restFieldSetOperationsHelper.updateIssueInputParameters(operations, (Function<JsonData, ServiceResult>)((Function)data -> {
            ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
            if (data.isNull()) {
                inputParameters.addCustomFieldValue(fieldId, new String[0]);
                return ServiceResultImpl.ok();
            }
            if (!data.isString()) {
                return ServiceResultImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.epic.link.error.epic.key.string.expected", new Object[0]);
            }
            IssueService.IssueResult epicResult = this.issueService.getIssue(user, data.asString());
            if (!epicResult.isValid()) {
                return ServiceResultImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.epic.error.not.found", new Object[0]);
            }
            IssueType epicIssueType = this.issueTypeService.getOrCreateEpicIssueType();
            if (!epicIssueType.equals(epicResult.getIssue().getIssueType())) {
                return ServiceResultImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.epic.error.not.found", new Object[0]);
            }
            if (epicIssueType.equals(issueCtx.getIssueType())) {
                return ServiceResultImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.epic.associate.error.issue.types.for.epic", this.getIssueKey(issue));
            }
            if (issueCtx.getIssueType() != null && issueCtx.getIssueType().isSubTask()) {
                return ServiceResultImpl.error("soft-error", ErrorCollection.Reason.VALIDATION_FAILED, "gh.epic.associate.error.subtask", "<br /><br />");
            }
            inputParameters.addCustomFieldValue(fieldId, new String[]{data.asString()});
            return ServiceResultImpl.ok();
        }));
    }

    private String getIssueKey(@Nullable Issue issue) {
        return issue != null ? issue.getKey() : "";
    }
}

