/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiclink;

import com.atlassian.greenhopper.customfield.epiclink.EpicLinkCustomFieldIndexer;
import com.atlassian.greenhopper.service.BridgeServiceLocator;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.issue.IssueDataService;
import com.atlassian.greenhopper.service.issue.callback.IssueIdCallback;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class EpicLinkResolver {
    private final CustomField epicLinkField;

    public EpicLinkResolver(CustomField epicLinkField) {
        this.epicLinkField = epicLinkField;
    }

    public Query getQuery(ApplicationUser user, boolean overrideSecurity, QueryLiteral rawValue) {
        if (rawValue.getLongValue() != null) {
            if (overrideSecurity || this.checkEpicIssueAccessible(user, rawValue.getLongValue())) {
                return new TermQuery(new Term(EpicLinkCustomFieldIndexer.getIdFieldId(this.epicLinkField), rawValue.asString()));
            }
            return new BooleanQuery.Builder().build();
        }
        if (rawValue.getStringValue() != null) {
            Set<Long> epicIssueIds = this.findEpicIssueIdsByEpicKeyOrLabel(user, overrideSecurity, rawValue.getStringValue());
            BooleanQuery.Builder combined = new BooleanQuery.Builder();
            for (Long epicIssueId : epicIssueIds) {
                combined.add((Query)new TermQuery(new Term(EpicLinkCustomFieldIndexer.getIdFieldId(this.epicLinkField), epicIssueId.toString())), BooleanClause.Occur.SHOULD);
            }
            return combined.build();
        }
        throw new IllegalStateException("Should not have gotten an empty query literal: " + rawValue);
    }

    public Set<Long> findEpicIssueIdsByEpicKeyOrLabel(ApplicationUser user, boolean overrideSecurity, String value) {
        EpicCustomFieldService epicCustomFieldService = this.getEpicCustomFieldService();
        CustomField epicLabelField = epicCustomFieldService.getDefaultEpicLabelField();
        com.atlassian.query.Query query = JqlQueryBuilder.newBuilder().where().customField(epicLabelField.getIdAsLong()).eq(value).or().issue(new String[]{value}).buildQuery();
        IssueIdCallback callback = new IssueIdCallback();
        IssueDataService issueDataService = this.getIssueDataService();
        ServiceOutcome<Void> outcome = !overrideSecurity ? issueDataService.find(user, query, callback) : issueDataService.findOverrideSecurity(user, query, callback);
        if (!outcome.isValid()) {
            return Collections.emptySet();
        }
        return callback.getIssueIds();
    }

    public boolean checkEpicIssueAccessible(ApplicationUser user, Long id) {
        com.atlassian.query.Query query = JqlQueryBuilder.newBuilder().buildQuery();
        IssueIdCallback callback = new IssueIdCallback();
        Term term = new Term("issue_id", id.toString());
        TermQuery epicLabelTerm = new TermQuery(term);
        IssueDataService issueDataService = this.getIssueDataService();
        ServiceOutcome<Void> outcome = issueDataService.find(user, query, callback, (Query)epicLabelTerm);
        return outcome.isValid() && !callback.getIssueIds().isEmpty();
    }

    private EpicCustomFieldService getEpicCustomFieldService() {
        return BridgeServiceLocator.getInstance().getEpicCustomFieldService();
    }

    private IssueDataService getIssueDataService() {
        return BridgeServiceLocator.getInstance().getIssueDataService();
    }
}

