/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiclink;

import com.atlassian.greenhopper.manager.issuelink.EpicLinkManager;
import com.atlassian.greenhopper.service.issue.AbstractIssueEventListener;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.issuelink.EpicService;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EpicLinkIssueEventListener
extends AbstractIssueEventListener {
    @Autowired
    private ChangeHistoryManager changeHistoryManager;
    @Autowired
    private ConstantsManager constantsManager;
    @Autowired
    EpicCustomFieldService epicCustomFieldService;
    @Autowired
    IssueTypeService issueTypeService;
    @Autowired
    EpicService epicService;
    @Autowired
    EpicLinkManager epicLinkManager;
    @Autowired
    IssueManager issueManager;

    @Override
    protected void doOnIssueEvent(Long typeId, Issue issue, IssueEvent event) {
        if (EventType.ISSUE_UPDATED_ID.equals(typeId)) {
            this.processUpdatedIssue(event.getUser(), issue);
        }
    }

    private void processUpdatedIssue(ApplicationUser user, Issue issue) {
        List allChangeHistories = this.changeHistoryManager.getChangeHistories(issue);
        if (!allChangeHistories.isEmpty()) {
            ChangeHistory last = (ChangeHistory)Iterables.getLast((Iterable)allChangeHistories);
            List changeItemBeans = last.getChangeItemBeans();
            ChangeItemBean issueTypeChange = null;
            ChangeItemBean parentChange = null;
            for (ChangeItemBean changeItemBean : changeItemBeans) {
                if (changeItemBean.getField().equals("issuetype")) {
                    issueTypeChange = changeItemBean;
                    continue;
                }
                if (!changeItemBean.getField().equals("Parent")) continue;
                parentChange = changeItemBean;
            }
            if (issueTypeChange != null) {
                this.processChangeItems(user, issue, issueTypeChange, parentChange);
            }
        }
    }

    private void processChangeItems(ApplicationUser user, Issue updatedIssue, ChangeItemBean issueTypeChange, ChangeItemBean parentChange) {
        String oldIssueTypeId = issueTypeChange.getFrom();
        String newIssueTypeId = issueTypeChange.getTo();
        if (StringUtils.isEmpty((CharSequence)oldIssueTypeId) || StringUtils.isEmpty((CharSequence)newIssueTypeId)) {
            this.log.warn("Cannot process issue type change as either the old or the new issue type is unknown: '%s', '%s'", oldIssueTypeId, newIssueTypeId);
            return;
        }
        IssueType oldIssueType = this.constantsManager.getIssueTypeObject(oldIssueTypeId);
        IssueType newIssueType = this.constantsManager.getIssueTypeObject(newIssueTypeId);
        if (oldIssueType == null || newIssueType == null) {
            this.log.warn("Cannot process issue type change as we can't find the issue types: '%s', '%s'", oldIssueTypeId, newIssueTypeId);
            return;
        }
        MutableIssue oldParent = null;
        MutableIssue newParent = null;
        if (parentChange != null) {
            Long newParentId;
            Long oldParentId = NumberUtils.toLong((String)parentChange.getFrom());
            if (oldParentId != null) {
                oldParent = this.issueManager.getIssueObject(oldParentId);
            }
            if ((newParentId = Long.valueOf(NumberUtils.toLong((String)parentChange.getTo()))) != null) {
                newParent = this.issueManager.getIssueObject(newParentId);
            }
        }
        this.processIssueTypeChange(user, updatedIssue, oldIssueType, newIssueType, (Issue)oldParent, (Issue)newParent);
    }

    public void processIssueTypeChange(ApplicationUser user, @Nonnull Issue updatedIssue, IssueType oldIssueType, IssueType newIssueType, Issue oldParent, Issue newParent) {
        Option<Issue> epic;
        if (oldIssueType.equals(newIssueType)) {
            return;
        }
        IssueType epicIssueType = this.issueTypeService.getOrCreateEpicIssueType();
        boolean parentToSub = !oldIssueType.isSubTask() && newIssueType.isSubTask();
        boolean subToParent = oldIssueType.isSubTask() && !newIssueType.isSubTask();
        boolean parentToParent = !oldIssueType.isSubTask() && !newIssueType.isSubTask();
        boolean changedFromEpic = epicIssueType.equals(oldIssueType);
        boolean changedToEpic = epicIssueType.equals(newIssueType);
        if (parentToParent) {
            if (changedFromEpic) {
                this.epicLinkManager.disassociateIssuesFromEpic(user, updatedIssue);
            } else if (changedToEpic) {
                this.epicLinkManager.disassociateEpicFromIssues(user, Sets.newHashSet((Object[])new Issue[]{updatedIssue}), true);
            }
        } else if (parentToSub) {
            if (changedFromEpic) {
                this.epicLinkManager.disassociateIssuesFromEpic(user, updatedIssue);
            } else {
                this.epicLinkManager.disassociateEpicFromIssues(user, Sets.newHashSet((Object[])new Issue[]{updatedIssue}), true);
            }
        } else if (subToParent && !changedToEpic && oldParent != null && (epic = this.epicLinkManager.getEpic(oldParent)).isDefined()) {
            this.epicLinkManager.associateIssuesWithEpic(user, epic, Sets.newHashSet((Object[])new Issue[]{updatedIssue}), true);
        }
    }
}

