/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiclink;

import com.atlassian.greenhopper.customfield.epiclink.EpicLinkHistoryData;
import com.atlassian.greenhopper.customfield.epiclink.EpicLinkHistoryEntry;
import com.atlassian.greenhopper.util.DateUtils;
import com.atlassian.greenhopper.util.NumberUtils;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.history.ChangeItemBean;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.joda.time.DateTime;

public class EpicLinkHistoryEntryFactory {
    private final ChangeHistoryManager changeHistoryManager;

    public EpicLinkHistoryEntryFactory(ChangeHistoryManager changeHistoryManager) {
        this.changeHistoryManager = changeHistoryManager;
    }

    public EpicLinkHistoryData getEpicChangeHistory(Issue issue, CustomField epicLinkCustomField) {
        Issue currentEpic = (Issue)epicLinkCustomField.getValue(issue);
        List changeItems = this.changeHistoryManager.getChangeItemsForField(issue, epicLinkCustomField.getName());
        HashSet<Long> allEpicIds = new HashSet<Long>();
        ArrayList<EpicLinkHistoryEntry> allChanges = new ArrayList<EpicLinkHistoryEntry>();
        this.getInitialChange(issue, currentEpic, changeItems).ifPresent(initialChange -> {
            allEpicIds.add(initialChange.getReferencedEntityId());
            allChanges.add((EpicLinkHistoryEntry)initialChange);
        });
        for (ChangeItemBean item : changeItems) {
            this.addChanges(item, allChanges, allEpicIds);
        }
        return new EpicLinkHistoryData(currentEpic, allEpicIds, allChanges);
    }

    private Optional<EpicLinkHistoryEntry> getInitialChange(Issue issue, Issue currentEpic, List<ChangeItemBean> changeItems) {
        if (this.isCurrentEpicAnInitialChange(currentEpic, changeItems)) {
            return Optional.of(new EpicLinkHistoryEntry(currentEpic.getId(), DateUtils.toDateTime(issue.getCreated()), true));
        }
        return changeItems.stream().findFirst().filter(cib -> cib.getFrom() != null).map(cib -> new EpicLinkHistoryEntry(Long.parseLong(cib.getFrom()), DateUtils.toDateTime(issue.getCreated()), true));
    }

    private boolean isCurrentEpicAnInitialChange(Issue currentEpic, List<ChangeItemBean> changeItems) {
        return changeItems.isEmpty() && currentEpic != null;
    }

    private void addChanges(ChangeItemBean bean, List<EpicLinkHistoryEntry> changes, Set<Long> allEpicIds) {
        DateTime date = DateUtils.toDateTime(bean.getCreated());
        Long removedFrom = NumberUtils.toLong(bean.getFrom());
        Long addedTo = NumberUtils.toLong(bean.getTo());
        if (addedTo != null) {
            allEpicIds.add(addedTo);
            changes.add(new EpicLinkHistoryEntry(addedTo, date, true));
        }
        if (removedFrom != null) {
            allEpicIds.add(removedFrom);
            changes.add(new EpicLinkHistoryEntry(removedFrom, date, false));
        }
    }
}

