/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiclink;

import com.atlassian.greenhopper.customfield.ReferencedEntityHistoryEntity;
import com.atlassian.greenhopper.util.NumberUtils;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;

public class EpicLinkHistoryEntry
extends ReferencedEntityHistoryEntity {
    public EpicLinkHistoryEntry(Long epicId, DateTime date, boolean added) {
        super(epicId, date, added);
    }

    public static EpicLinkHistoryEntry fromLuceneValue(String data) {
        DateTime date;
        String[] parts = data.split(";");
        if (parts.length != 3) {
            return null;
        }
        Long epicId = NumberUtils.toLong(parts[0]);
        if (epicId == null) {
            return null;
        }
        try {
            date = ISODateTimeFormat.dateTime().parseDateTime(parts[1]);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        boolean added = parts[2].equals("a");
        return new EpicLinkHistoryEntry(epicId, date, added);
    }
}

