/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiclink;

import com.atlassian.greenhopper.customfield.epiclink.EpicLinkCustomFieldIndexer;
import com.atlassian.greenhopper.customfield.epiclink.EpicLinkResolver;
import com.atlassian.greenhopper.customfield.searcher.GhOperatorSpecificQueryFactory;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.query.operator.Operator;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class EpicLinkEqualityQueryFactory
implements GhOperatorSpecificQueryFactory {
    private final LoggerWrapper logger = LoggerWrapper.with(this.getClass());
    private final CustomField customField;
    private final EpicLinkResolver epicLinkResolver;

    public EpicLinkEqualityQueryFactory(CustomField customField, EpicLinkResolver epicLinkResolver) {
        this.customField = customField;
        this.epicLinkResolver = epicLinkResolver;
    }

    @Override
    public QueryFactoryResult createQueryForSingleValue(QueryCreationContext queryCreationContext, String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator != Operator.EQUALS && operator != Operator.NOT_EQUALS) {
            this.logger.warn("Creating an equality query for a single value for field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s' and '%s'", fieldName, operator, Operator.EQUALS, Operator.NOT_EQUALS);
            return QueryFactoryResult.createFalseResult();
        }
        return this.createResult(queryCreationContext, operator, rawValues);
    }

    @Override
    public QueryFactoryResult createQueryForMultipleValues(QueryCreationContext queryCreationContext, String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (operator == Operator.IN || operator == Operator.NOT_IN) {
            return this.createResult(queryCreationContext, operator, rawValues);
        }
        this.logger.warn("Creating an equality query for multiple values for field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s' and '%s'", fieldName, operator, Operator.IN, Operator.NOT_IN);
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public QueryFactoryResult createQueryForEmptyOperand(QueryCreationContext queryCreationContext, String fieldName, Operator operator) {
        if (operator == Operator.IS || operator == Operator.EQUALS) {
            return new QueryFactoryResult(this.getIsEmptyQuery());
        }
        if (operator == Operator.IS_NOT || operator == Operator.NOT_EQUALS) {
            return new QueryFactoryResult(this.getIsEmptyQuery(), true);
        }
        this.logger.warn("Creating an equality query for an empty value for field '%s' using unsupported operator: '%s', returning a false result (no issues). Supported operators are: '%s','%s', '%s' and '%s'", fieldName, operator, Operator.IS, Operator.EQUALS, Operator.IS_NOT, Operator.NOT_EQUALS);
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains(operator);
    }

    private QueryFactoryResult createResult(QueryCreationContext queryCreationContext, Operator operator, List<QueryLiteral> rawValues) {
        if (operator == Operator.IN || operator == Operator.EQUALS) {
            return this.handleIn(queryCreationContext, rawValues);
        }
        if (operator == Operator.NOT_IN || operator == Operator.NOT_EQUALS) {
            return this.handleNotIn(queryCreationContext, rawValues);
        }
        return QueryFactoryResult.createFalseResult();
    }

    private QueryFactoryResult handleIn(QueryCreationContext queryCreationContext, List<QueryLiteral> rawValues) {
        if (rawValues.size() == 1) {
            QueryLiteral rawValue = rawValues.get(0);
            Query query = rawValue.isEmpty() ? this.getIsEmptyQuery() : this.getQuery(queryCreationContext, rawValue);
            return new QueryFactoryResult(query);
        }
        BooleanQuery.Builder combined = new BooleanQuery.Builder();
        boolean emptyAdded = false;
        for (QueryLiteral rawValue : rawValues) {
            if (!emptyAdded && rawValue.isEmpty()) {
                combined.add(this.getIsEmptyQuery(), BooleanClause.Occur.SHOULD);
                emptyAdded = true;
                continue;
            }
            if (rawValue.isEmpty()) continue;
            combined.add(this.getQuery(queryCreationContext, rawValue), BooleanClause.Occur.SHOULD);
        }
        return new QueryFactoryResult((Query)combined.build());
    }

    private QueryFactoryResult handleNotIn(QueryCreationContext queryCreationContext, List<QueryLiteral> rawValues) {
        ArrayList<Query> notQueries = new ArrayList<Query>();
        for (QueryLiteral rawValue : rawValues) {
            if (rawValue.isEmpty()) continue;
            notQueries.add(this.getQuery(queryCreationContext, rawValue));
        }
        if (notQueries.isEmpty()) {
            return new QueryFactoryResult(this.getIsEmptyQuery(), true);
        }
        BooleanQuery.Builder boolQuery = new BooleanQuery.Builder();
        boolQuery.add(this.getIsEmptyQuery(), BooleanClause.Occur.MUST_NOT);
        for (Query query : notQueries) {
            boolQuery.add(query, BooleanClause.Occur.MUST_NOT);
        }
        return new QueryFactoryResult((Query)boolQuery.build(), false);
    }

    private Query getQuery(QueryCreationContext queryCreationContext, QueryLiteral rawValue) {
        return this.epicLinkResolver.getQuery(queryCreationContext.getApplicationUser(), queryCreationContext.isSecurityOverriden(), rawValue);
    }

    private Query getIsEmptyQuery() {
        return new TermQuery(new Term(EpicLinkCustomFieldIndexer.getIdFieldId(this.customField), "-1"));
    }
}

