/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiclink;

import com.atlassian.greenhopper.customfield.epiclink.EpicLinkHistoryData;
import com.atlassian.greenhopper.customfield.epiclink.EpicLinkHistoryEntry;
import com.atlassian.greenhopper.customfield.epiclink.EpicLinkHistoryEntryFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.util.CaseFolding;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public class EpicLinkCustomFieldIndexer
implements FieldIndexer {
    private final CustomField customField;
    private final EpicLinkHistoryEntryFactory epicLinkHistoryEntryFactory;

    protected EpicLinkCustomFieldIndexer(CustomField customField, ChangeHistoryManager changeHistoryManager) {
        this.customField = customField;
        this.epicLinkHistoryEntryFactory = new EpicLinkHistoryEntryFactory(changeHistoryManager);
    }

    public String getId() {
        return EpicLinkCustomFieldIndexer.getIdFieldId(this.customField);
    }

    public String getDocumentFieldId() {
        return EpicLinkCustomFieldIndexer.getIdFieldId(this.customField);
    }

    public void addIndex(Document doc, Issue issue) {
        String keyIndexValueFolded;
        String keyIndexValue;
        String idIndexValue;
        Object epicObject = this.customField.getValue(issue);
        if (epicObject == null) {
            idIndexValue = "-1";
            keyIndexValue = "-1";
            keyIndexValueFolded = "-1";
        } else {
            Issue epic = (Issue)epicObject;
            idIndexValue = epic.getId().toString();
            keyIndexValue = epic.getKey();
            keyIndexValueFolded = EpicLinkCustomFieldIndexer.getKeyFoldedValue(epic.getKey());
        }
        String idFieldId = EpicLinkCustomFieldIndexer.getIdFieldId(this.customField);
        doc.add((IndexableField)new StringField(idFieldId, idIndexValue, Field.Store.YES));
        doc.add((IndexableField)new SortedDocValuesField(idFieldId, new BytesRef((CharSequence)idIndexValue)));
        doc.add((IndexableField)new StoredField(EpicLinkCustomFieldIndexer.getKeyFieldId(this.customField), keyIndexValue));
        String keyFoldedFieldId = EpicLinkCustomFieldIndexer.getKeyFoldedFieldId(this.customField);
        doc.add((IndexableField)new StringField(keyFoldedFieldId, keyIndexValueFolded, Field.Store.NO));
        doc.add((IndexableField)new SortedDocValuesField(keyFoldedFieldId, new BytesRef((CharSequence)keyIndexValueFolded)));
        EpicLinkHistoryData data = this.epicLinkHistoryEntryFactory.getEpicChangeHistory(issue, this.customField);
        String historyFieldId = EpicLinkCustomFieldIndexer.getHistoryFieldId(this.customField);
        if (data.hasEverHadEpic()) {
            for (Long epicId : data.getAllIds()) {
                doc.add((IndexableField)new StringField(historyFieldId, String.valueOf(epicId), Field.Store.YES));
                doc.add((IndexableField)new SortedSetDocValuesField(historyFieldId, new BytesRef((CharSequence)String.valueOf(epicId.toString()))));
            }
        } else {
            doc.add((IndexableField)new StringField(historyFieldId, "-1", Field.Store.NO));
            doc.add((IndexableField)new SortedSetDocValuesField(historyFieldId, new BytesRef((CharSequence)"-1")));
        }
        String changesFieldId = EpicLinkCustomFieldIndexer.getChangesFieldId(this.customField);
        for (EpicLinkHistoryEntry entry : data.getChanges()) {
            doc.add((IndexableField)new StoredField(changesFieldId, entry.toLuceneValue()));
        }
    }

    public boolean isFieldVisibleAndInScope(Issue issue) {
        return true;
    }

    public static String getIdFieldId(CustomField customField) {
        return customField.getId();
    }

    public static String getKeyFieldId(CustomField customField) {
        return customField.getId() + "_key";
    }

    public static String getKeyFoldedFieldId(CustomField customField) {
        return customField.getId() + "_key_folded";
    }

    public static String getChangesFieldId(CustomField customField) {
        return customField.getId() + "_changes";
    }

    public static String getHistoryFieldId(CustomField customField) {
        return customField.getId() + "_history";
    }

    public static String getKeyFoldedValue(String key) {
        return CaseFolding.foldString((String)key);
    }
}

