/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiclink;

import com.atlassian.greenhopper.customfield.epiclabel.EpicLabelProvider;
import com.atlassian.greenhopper.service.BridgeServiceLocator;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.issuelink.EpicNamesResult;
import com.atlassian.greenhopper.service.issuelink.EpicPickerService;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.List;

public class EpicLinkClauseValueGenerator
implements ClauseValuesGenerator {
    private static final int MAX_RESULTS = 15;

    public ClauseValuesGenerator.Results getPossibleValues(ApplicationUser searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        if (maxNumResults > 15) {
            maxNumResults = 15;
        }
        ArrayList epicValues = new ArrayList();
        ServiceOutcome<List<EpicNamesResult>> outcome = this.getEpicPickerService().listEpicNames(searcher, valuePrefix, maxNumResults, null, false, false);
        if (outcome.isInvalid()) {
            return new ClauseValuesGenerator.Results(epicValues);
        }
        EpicLabelProvider epicLabelProvider = BridgeServiceLocator.getInstance().getEpicLabelProvider();
        outcome.getValue().forEach(epicModels -> epicModels.getNames().stream().forEach(model -> {
            String epicLabel = epicLabelProvider.getEpicLabel(model.getEpicKey(), model.getEpicName());
            String label = String.format("%s - (%s)", epicLabel, model.getEpicKey());
            epicValues.add(new ClauseValuesGenerator.Result(model.getEpicKey(), label));
        }));
        return new ClauseValuesGenerator.Results(epicValues);
    }

    private EpicPickerService getEpicPickerService() {
        return BridgeServiceLocator.getInstance().getEpicPickerService();
    }
}

