/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiclink;

import com.atlassian.greenhopper.customfield.epiclink.EpicLinkResolver;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.query.clause.TerminalClause;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public class EpicLinkClauseValidator
implements ClauseValidator {
    private final SupportedOperatorsValidator supportedOperatorsValidator = new SupportedOperatorsValidator(new Collection[]{OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY});
    private final EpicLinkResolver epicLinkResolver;
    private final JqlOperandResolver operandResolver;
    private final I18nHelper.BeanFactory i18nFactory;

    public EpicLinkClauseValidator(JqlOperandResolver operandResolver, EpicLinkResolver epicLinkResolver, I18nHelper.BeanFactory i18nFactory) {
        this.epicLinkResolver = epicLinkResolver;
        this.operandResolver = operandResolver;
        this.i18nFactory = i18nFactory;
    }

    public MessageSet validate(final ApplicationUser searcher, @Nonnull TerminalClause terminalClause) {
        MessageSet messages = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        LazyReference<I18nHelper> i18nRef = new LazyReference<I18nHelper>(){

            @Override
            protected I18nHelper create() throws Exception {
                return EpicLinkClauseValidator.this.i18nFactory.getInstance(searcher);
            }
        };
        List<QueryLiteral> rawValues = this.getRawValues(searcher, terminalClause);
        for (QueryLiteral rawValue : rawValues) {
            Set<Long> epicIssueIdsByEpicLabel;
            if (rawValue.getLongValue() != null) {
                if (this.epicLinkResolver.checkEpicIssueAccessible(searcher, rawValue.getLongValue())) continue;
                messages.addErrorMessage(((I18nHelper)i18nRef.get()).getText("gh.epic.link.searcher.validate.no.parent.epic.with.this.id", rawValue.getLongValue().toString()));
                continue;
            }
            if (rawValue.getStringValue() == null || !(epicIssueIdsByEpicLabel = this.epicLinkResolver.findEpicIssueIdsByEpicKeyOrLabel(searcher, false, rawValue.getStringValue())).isEmpty()) continue;
            messages.addErrorMessage(((I18nHelper)i18nRef.get()).getText("gh.epic.link.searcher.validate.no.parent.epic.with.this.key.label", rawValue.getStringValue()));
        }
        return messages;
    }

    private List<QueryLiteral> getRawValues(ApplicationUser searcher, TerminalClause clause) {
        return this.operandResolver.getValues(searcher, clause.getOperand(), clause);
    }
}

