/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiclink;

import com.atlassian.greenhopper.customfield.CustomFieldMetadata;
import com.atlassian.greenhopper.customfield.MetadataCFType;
import com.atlassian.greenhopper.customfield.epiclabel.EpicLabelProviderImpl;
import com.atlassian.greenhopper.customfield.epiclink.EpicLinkRestFieldOperationsHandler;
import com.atlassian.greenhopper.manager.issuelink.EpicLinkManager;
import com.atlassian.greenhopper.service.issue.IssueTypePrototype;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.issuelink.EpicService;
import com.atlassian.greenhopper.service.issuelink.IssueLinkRequest;
import com.atlassian.greenhopper.service.issuelink.IssueUnlinkRequest;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.rest.RestCustomFieldTypeOperations;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class EpicLinkCFType
extends AbstractCustomFieldType<Issue, Issue>
implements MetadataCFType,
RestCustomFieldTypeOperations {
    public static final CustomFieldMetadata CUSTOMFIELD_METADATA = CustomFieldMetadata.builder().setFieldName("gh.epic.link.name").setFieldDescription("gh.epic.link.desc").setFieldType("com.pyxis.greenhopper.jira:gh-epic-link").setFieldSearcher("com.pyxis.greenhopper.jira:gh-epic-link-searcher").setIssueTypePrototypes(IssueTypePrototype.ALL).setLockField(true).build();
    private final EpicLinkManager epicLinkManager;
    private final EpicService epicService;
    private final IssueManager issueManager;
    private final IssueTypeService issueTypeService;
    private final EpicCustomFieldService epicCustomFieldService;
    private final JiraAuthenticationContext authCtx;
    private final VelocityRequestContextFactory requestContextFactory;
    private final EpicLabelProviderImpl epicLabelProvider;
    private final EpicLinkRestFieldOperationsHandler epicLinkRestFieldOperationsHandler;
    static final String ISSUE_KEY_PREFIX = "key:";

    protected EpicLinkCFType(EpicLinkManager epicLinkManager, EpicService epicService, IssueManager issueManager, IssueTypeService issueTypeService, EpicCustomFieldService epicCustomFieldService, JiraAuthenticationContext authCtx, VelocityRequestContextFactory requestContextFactory, EpicLabelProviderImpl epicLabelProvider, EpicLinkRestFieldOperationsHandler epicLinkRestFieldOperationsHandler) {
        this.epicLinkManager = epicLinkManager;
        this.epicService = epicService;
        this.issueManager = issueManager;
        this.issueTypeService = issueTypeService;
        this.epicCustomFieldService = epicCustomFieldService;
        this.authCtx = authCtx;
        this.requestContextFactory = requestContextFactory;
        this.epicLabelProvider = epicLabelProvider;
        this.epicLinkRestFieldOperationsHandler = epicLinkRestFieldOperationsHandler;
    }

    public String getStringFromSingularObject(Issue issue) {
        if (issue == null) {
            return "";
        }
        return issue.getKey();
    }

    @Nullable
    public Issue getSingularObjectFromString(@Nullable String epicKey) {
        Issue epic;
        if (StringUtils.isBlank((CharSequence)epicKey)) {
            return null;
        }
        epicKey = EpicLinkCFType.stripIssuePrefix(epicKey);
        try {
            epic = this.getEpicByKey(epicKey);
        }
        catch (DataAccessException noKeyFound) {
            throw new FieldValidationException(this.getI18nBean().getText("gh.epic.link.error.not.found.by.key", epicKey));
        }
        if (epic == null) {
            throw new FieldValidationException(this.getI18nBean().getText("gh.epic.link.error.not.found.by.key", epicKey));
        }
        return epic;
    }

    public Set<Long> remove(CustomField field) {
        return Sets.newHashSet();
    }

    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        String epicKey = this.getEpicKeyFromCustomFieldParams(relevantParams);
        if (epicKey == null) {
            return;
        }
        Issue epic = this.getEpicByKey(epicKey = EpicLinkCFType.stripIssuePrefix(epicKey));
        if (epic == null) {
            this.addEpicLinkNotFoundByKeyError(errorCollectionToAddTo, epicKey, config);
        } else if (!this.isIssueOfTypeEpic(epic)) {
            this.addIssueTypeNotEpicError(errorCollectionToAddTo, epic, config);
        }
    }

    public void createValue(CustomField field, @Nonnull Issue issue, @Nonnull Issue epic) {
        Preconditions.checkNotNull((Object)issue);
        Preconditions.checkNotNull((Object)epic);
        this.associateIssueWithEpic(issue, epic);
    }

    public void updateValue(CustomField field, @Nonnull Issue issue, Issue epic) {
        Preconditions.checkNotNull((Object)issue);
        if (epic == null) {
            this.disassociateIssueFromEpic(issue);
        } else {
            this.associateIssueWithEpic(issue, epic);
        }
    }

    public Issue getValueFromCustomFieldParams(CustomFieldParams parameters) {
        String epicKey = this.getEpicKeyFromCustomFieldParams(parameters);
        return this.getSingularObjectFromString(epicKey);
    }

    public Object getStringValueFromCustomFieldParams(CustomFieldParams parameters) {
        return parameters.getFirstValueForNullKey();
    }

    @Nullable
    public Issue getValueFromIssue(CustomField field, Issue issue) {
        Option<Issue> epic = this.epicLinkManager.getEpic(issue);
        return (Issue)epic.getOrNull();
    }

    public Issue getDefaultValue(FieldConfig fieldConfig) {
        return null;
    }

    public void setDefaultValue(FieldConfig fieldConfig, Issue value) {
    }

    public String getChangelogValue(CustomField field, Issue value) {
        return Optional.ofNullable(value).map(Issue::getId).map(Object::toString).orElse("");
    }

    public String getChangelogString(CustomField field, Issue value) {
        return Optional.ofNullable(value).map(Issue::getKey).orElse(null);
    }

    @Override
    public CustomFieldMetadata getMetadata() {
        return CUSTOMFIELD_METADATA;
    }

    public String getEpicKey(String key) {
        Issue epic;
        try {
            epic = this.getSingularObjectFromString(key);
        }
        catch (FieldValidationException keyNotFound) {
            epic = null;
        }
        return this.getEpicKey(epic);
    }

    public String getEpicKey(@Nullable Issue epic) {
        if (epic == null) {
            return null;
        }
        return epic.getKey();
    }

    public String getEpicDisplayName(String key) {
        Issue epic;
        try {
            epic = this.getSingularObjectFromString(key);
        }
        catch (FieldValidationException keyNotFound) {
            epic = null;
        }
        return this.getEpicDisplayName(epic);
    }

    public String getEpicDisplayName(@Nullable Issue epic) {
        if (epic == null) {
            return null;
        }
        return this.epicLabelProvider.getEpicLabel(epic);
    }

    public String getEpicColor(String key) {
        Issue epic;
        try {
            epic = this.getSingularObjectFromString(key);
        }
        catch (FieldValidationException keyNotFound) {
            epic = null;
        }
        return this.getEpicColor(epic);
    }

    public String getEpicColor(@Nullable Issue epic) {
        if (epic == null) {
            return null;
        }
        CustomField epicColorCustomField = this.epicCustomFieldService.getDefaultEpicColorField();
        return (String)epic.getCustomFieldValue(epicColorCustomField);
    }

    public boolean isIssueOfTypeEpic(@Nonnull Issue issue) {
        Preconditions.checkNotNull((Object)issue);
        IssueType epicIssueType = this.issueTypeService.getOrCreateEpicIssueType();
        return issue.getIssueTypeObject().equals(epicIssueType);
    }

    public boolean isSubtask(@Nonnull Issue issue) {
        Preconditions.checkNotNull((Object)issue);
        return issue.isSubTask();
    }

    public String getIssueOfTypeEpicErrorMessage() {
        return this.getI18nBean().getText("gh.epic.link.error.issue.type.epic");
    }

    public String getSubtaskErrorMessage() {
        return this.getI18nBean().getText("gh.epic.link.error.subtask");
    }

    public String getEpicUrl(String epicKey) {
        Issue epic = this.getEpicByKey(epicKey);
        return this.getEpicUrl(epic);
    }

    public String getEpicUrl(@Nullable Issue epicIssue) {
        if (epicIssue == null) {
            return "";
        }
        String url = this.requestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
        url = url + "/browse/" + epicIssue.getKey();
        return url;
    }

    private Issue getEpicByKey(@Nullable String epicKey) {
        if (StringUtils.isBlank((CharSequence)epicKey)) {
            return null;
        }
        return this.issueManager.getIssueObject(epicKey);
    }

    @Nullable
    private String getEpicKeyFromCustomFieldParams(CustomFieldParams relevantParams) {
        List valuesForNullKey = (List)relevantParams.getValuesForNullKey();
        if (valuesForNullKey == null || valuesForNullKey.isEmpty()) {
            return null;
        }
        return (String)valuesForNullKey.get(valuesForNullKey.size() - 1);
    }

    private void addEpicLinkNotFoundByKeyError(ErrorCollection errorCollectionToAddTo, String epicKey, FieldConfig config) {
        String errorMessage = this.getI18nBean().getText("gh.epic.link.error.not.found.by.key", epicKey);
        errorCollectionToAddTo.addError(config.getCustomField().getId(), errorMessage, ErrorCollection.Reason.VALIDATION_FAILED);
    }

    private void addIssueTypeNotEpicError(ErrorCollection errorCollectionToAddTo, @Nonnull Issue issue, FieldConfig config) {
        Preconditions.checkNotNull((Object)issue);
        IssueType epicIssueType = this.issueTypeService.getOrCreateEpicIssueType();
        String errorMessage = this.getI18nBean().getText("gh.epic.associate.error.issue.types", issue.getKey(), epicIssueType.getName());
        errorCollectionToAddTo.addError(config.getCustomField().getId(), errorMessage, ErrorCollection.Reason.VALIDATION_FAILED);
    }

    private void associateIssueWithEpic(@Nonnull Issue issue, @Nonnull Issue epic) {
        Preconditions.checkNotNull((Object)issue);
        Preconditions.checkNotNull((Object)epic);
        ApplicationUser user = this.authCtx.getLoggedInUser();
        HashSet issueSet = Sets.newHashSet((Object[])new Issue[]{issue});
        this.epicService.addIssuesToEpic(IssueLinkRequest.linkEpic(user, epic, (Set<Issue>)issueSet).withoutDispatchingEvent());
    }

    private void disassociateIssueFromEpic(@Nonnull Issue issue) {
        Preconditions.checkNotNull((Object)issue);
        ApplicationUser user = this.authCtx.getLoggedInUser();
        HashSet issueSet = Sets.newHashSet((Object[])new Issue[]{issue});
        this.epicService.removeEpicFromIssues(IssueUnlinkRequest.unlinkEpic(user, issueSet).withoutDispatchingEvent());
    }

    private static String stripIssuePrefix(@Nullable String epicKey) {
        if (epicKey == null) {
            return null;
        }
        if (epicKey.startsWith(ISSUE_KEY_PREFIX)) {
            epicKey = epicKey.substring(ISSUE_KEY_PREFIX.length());
        }
        return epicKey;
    }

    public RestFieldOperationsHandler getRestFieldOperation(CustomField field) {
        return this.epicLinkRestFieldOperationsHandler;
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx, CustomField field) {
        return null;
    }
}

