/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiclabel;

import com.atlassian.greenhopper.customfield.AbstractCustomFieldSearcher;
import com.atlassian.greenhopper.customfield.epiclabel.EpicLabelClauseQueryFactory;
import com.atlassian.greenhopper.customfield.epiclabel.EpicLabelClauseValidator;
import com.atlassian.greenhopper.customfield.epiclabel.EpicLabelCustomFieldIndexer;
import com.atlassian.greenhopper.customfield.epiclabel.EpicLabelRenderer;
import com.atlassian.greenhopper.issue.index.FoldingIndexValueConverter;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.NaturallyOrderedCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.SingleValueCustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleAllTextCustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.searchers.transformer.FreeTextCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.search.SortField;

public class EpicLabelSearcher
extends AbstractCustomFieldSearcher
implements CustomFieldSearcher,
NaturallyOrderedCustomFieldSearcher {
    private final FieldVisibilityManager fieldVisibilityManager;
    private final JqlOperandResolver jqlOperandResolver;
    private final CustomFieldInputHelper customFieldInputHelper;

    public EpicLabelSearcher(FieldVisibilityManager fieldVisibilityManager, JqlOperandResolver jqlOperandResolver, CustomFieldInputHelper customFieldInputHelper) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.jqlOperandResolver = jqlOperandResolver;
        this.customFieldInputHelper = customFieldInputHelper;
    }

    public void init(CustomField field) {
        ClauseNames names = field.getClauseNames();
        EpicLabelCustomFieldIndexer indexer = new EpicLabelCustomFieldIndexer(field);
        SingleValueCustomFieldValueProvider customFieldValueProvider = new SingleValueCustomFieldValueProvider();
        this.setSearcherInformation(new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field)));
        this.setSearchRenderer(new EpicLabelRenderer(names, this.getDescriptor(), field, (CustomFieldValueProvider)customFieldValueProvider, this.fieldVisibilityManager));
        this.setSearchInputTransformer((SearchInputTransformer)new FreeTextCustomFieldSearchInputTransformer(field, names, this.getSearchInformation().getId(), this.customFieldInputHelper));
        this.setCustomFieldSearcherClauseHandler((CustomFieldSearcherClauseHandler)new SimpleAllTextCustomFieldSearcherClauseHandler((ClauseValidator)new EpicLabelClauseValidator(), (ClauseQueryFactory)new EpicLabelClauseQueryFactory(field, this.jqlOperandResolver, new FoldingIndexValueConverter()), OperatorClasses.NON_RELATIONAL_OPERATORS, JiraDataTypes.TEXT));
    }

    public String getSortField(CustomField customField) {
        return customField.getId();
    }

    public SortField.Type getSortFieldType() {
        return SortField.Type.STRING;
    }
}

