/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiclabel;

import com.atlassian.greenhopper.customfield.epiclabel.EpicLabelProvider;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.security.JiraAuthenticationContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EpicLabelProviderImpl
implements EpicLabelProvider {
    @Autowired
    private JiraAuthenticationContext authCtx;
    @Autowired
    private I18nFactoryService i18n;
    @Autowired
    private EpicCustomFieldService epicCustomFieldService;

    @Override
    public String getEpicLabel(Issue epic) {
        CustomField epicLabelCustomField = this.epicCustomFieldService.getDefaultEpicLabelField();
        String epicLabel = (String)epic.getCustomFieldValue(epicLabelCustomField);
        if (StringUtils.isBlank((CharSequence)epicLabel)) {
            epicLabel = this.i18n.getI18n(this.authCtx.getUser()).getText("gh.epic.label.unlabelled") + "-" + epic.getKey();
        }
        return epicLabel;
    }

    @Override
    public String getEpicLabel(String epicKey, String epicLabel) {
        if (epicLabel == null) {
            epicLabel = this.i18n.getI18n(this.authCtx.getUser()).getText("gh.epic.label.unlabelled") + "-" + epicKey;
        }
        return epicLabel;
    }
}

