/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiclabel;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.index.indexers.phrase.PhraseQuerySupportField;
import com.atlassian.jira.util.CaseFolding;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public class EpicLabelCustomFieldIndexer
implements FieldIndexer {
    private final CustomField customField;

    public EpicLabelCustomFieldIndexer(CustomField customField) {
        this.customField = customField;
    }

    public String getId() {
        return this.customField.getId();
    }

    public String getDocumentFieldId() {
        return this.customField.getId();
    }

    public void addIndex(Document doc, Issue issue) {
        String value = this.customField.getValueFromIssue(issue);
        String fieldId = EpicLabelCustomFieldIndexer.getFieldId(this.customField);
        if (StringUtils.isNotBlank((CharSequence)value) && this.isFieldVisibleAndInScope(issue)) {
            doc.add((IndexableField)new TextField(fieldId, value, Field.Store.YES));
            doc.add((IndexableField)new SortedDocValuesField(fieldId, new BytesRef((CharSequence)value)));
            String phraseForIndexField = PhraseQuerySupportField.forIndexField((String)fieldId);
            doc.add((IndexableField)new TextField(phraseForIndexField, value, Field.Store.YES));
            doc.add((IndexableField)new SortedDocValuesField(phraseForIndexField, new BytesRef((CharSequence)value)));
            String foldedFieldId = EpicLabelCustomFieldIndexer.getFoldedFieldId(this.customField);
            String foldedValue = EpicLabelCustomFieldIndexer.getFoldedValue(value);
            doc.add((IndexableField)new StringField(foldedFieldId, foldedValue, Field.Store.NO));
            doc.add((IndexableField)new SortedDocValuesField(foldedFieldId, new BytesRef((CharSequence)foldedValue)));
        }
    }

    public static String getFieldId(CustomField customField) {
        return customField.getId();
    }

    public static String getFoldedFieldId(CustomField customField) {
        return customField.getId() + "_folded";
    }

    public static String getFoldedValue(String value) {
        return CaseFolding.foldString((String)value);
    }

    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.customField.getRelevantConfig(issue) != null;
    }
}

