/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiclabel;

import com.atlassian.core.util.StringUtils;
import com.atlassian.greenhopper.customfield.CustomFieldMetadata;
import com.atlassian.greenhopper.customfield.MetadataCFType;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.issue.IssueTypePrototype;
import com.atlassian.jira.issue.customfields.impl.GenericTextCFType;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import java.util.Collection;

public class EpicLabelCFType
extends GenericTextCFType
implements MetadataCFType {
    public static final CustomFieldMetadata CUSTOMFIELD_METADATA = CustomFieldMetadata.builder().setFieldName("gh.epic.label.name").setFieldDescription("gh.epic.label.desc").setFieldType("com.pyxis.greenhopper.jira:gh-epic-label").setFieldSearcher("com.pyxis.greenhopper.jira:gh-epic-label-searcher").setIssueTypePrototypes(IssueTypePrototype.EPIC).setLockField(true).setRequireField(true).build();
    private I18nFactoryService i18nFactory;
    private JiraAuthenticationContext authenticationContext;

    public EpicLabelCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager, I18nFactoryService i18nFactory, JiraAuthenticationContext authenticationContext) {
        super(customFieldValuePersister, genericConfigManager);
        this.i18nFactory = i18nFactory;
        this.authenticationContext = authenticationContext;
    }

    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        Collection values = relevantParams.getValuesForNullKey();
        if (values == null) {
            return;
        }
        for (Object value : values) {
            String label = (String)value;
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)label) && !org.apache.commons.lang3.StringUtils.isWhitespace((CharSequence)label)) continue;
            errorCollectionToAddTo.addError(config.getFieldId(), this.i18nFactory.getI18n(this.authenticationContext.getUser()).getText("gh.rapid.view.error.epic.name.required"), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    @Override
    public CustomFieldMetadata getMetadata() {
        return CUSTOMFIELD_METADATA;
    }

    public boolean isRenderable() {
        return true;
    }

    public boolean valuesEqual(String v1, String v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        return StringUtils.equalsIgnoreLineTerminators((String)v1, (String)v2);
    }
}

