/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiccolor;

import com.atlassian.greenhopper.customfield.AbstractCustomFieldSearcher;
import com.atlassian.greenhopper.customfield.epiccolor.EpicColorCustomFieldIndexer;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.NaturallyOrderedCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.SingleValueCustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.CustomFieldRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.searchers.transformer.ExactTextCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.ActualValueCustomFieldClauseQueryFactory;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.util.IndexValueConverter;
import com.atlassian.jira.jql.util.SimpleIndexValueConverter;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.ExactTextCustomFieldValidator;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.search.SortField;

public class EpicColorSearcher
extends AbstractCustomFieldSearcher
implements CustomFieldSearcher,
NaturallyOrderedCustomFieldSearcher {
    private final FieldVisibilityManager fieldVisibilityManager;
    private final JqlOperandResolver jqlOperandResolver;
    private final CustomFieldInputHelper customFieldInputHelper;

    public EpicColorSearcher(FieldVisibilityManager fieldVisibilityManager, JqlOperandResolver jqlOperandResolver, CustomFieldInputHelper customFieldInputHelper) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.jqlOperandResolver = jqlOperandResolver;
        this.customFieldInputHelper = customFieldInputHelper;
    }

    public void init(CustomField field) {
        ClauseNames names = field.getClauseNames();
        EpicColorCustomFieldIndexer indexer = new EpicColorCustomFieldIndexer(this.fieldVisibilityManager, field);
        SingleValueCustomFieldValueProvider customFieldValueProvider = new SingleValueCustomFieldValueProvider();
        this.setSearcherInformation(new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(indexer), new AtomicReference<CustomField>(field)));
        this.setSearchRenderer((SearchRenderer)new CustomFieldRenderer(names, this.getDescriptor(), field, (CustomFieldValueProvider)customFieldValueProvider, this.fieldVisibilityManager));
        this.setSearchInputTransformer((SearchInputTransformer)new ExactTextCustomFieldSearchInputTransformer(field, names, this.getSearchInformation().getId(), this.customFieldInputHelper));
        this.setCustomFieldSearcherClauseHandler((CustomFieldSearcherClauseHandler)new SimpleCustomFieldSearcherClauseHandler((ClauseValidator)new ExactTextCustomFieldValidator(), (ClauseQueryFactory)new ActualValueCustomFieldClauseQueryFactory(field.getId(), this.jqlOperandResolver, (IndexValueConverter)new SimpleIndexValueConverter(false), false), OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY, JiraDataTypes.TEXT));
    }

    public String getSortField(CustomField customField) {
        return customField.getId();
    }

    public SortField.Type getSortFieldType() {
        return SortField.Type.STRING;
    }
}

