/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield.epiccolor;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public class EpicColorCustomFieldIndexer
implements FieldIndexer {
    private final FieldVisibilityManager fieldVisibilityManager;
    private final CustomField customField;

    public EpicColorCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.customField = customField;
    }

    public String getId() {
        return this.customField.getId();
    }

    public String getDocumentFieldId() {
        return this.customField.getId();
    }

    public void addIndex(Document doc, Issue issue) {
        String value = this.customField.getValueFromIssue(issue);
        String documentFieldId = this.getDocumentFieldId();
        if (this.isFieldVisibleAndInScope(issue) && StringUtils.isNotBlank((CharSequence)value)) {
            doc.add((IndexableField)new StringField(documentFieldId, value, Field.Store.YES));
            doc.add((IndexableField)new SortedDocValuesField(documentFieldId, new BytesRef((CharSequence)value)));
        } else {
            doc.add((IndexableField)new StringField(documentFieldId, "-1", Field.Store.NO));
            doc.add((IndexableField)new SortedDocValuesField(documentFieldId, new BytesRef((CharSequence)"-1")));
        }
    }

    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.customField.getRelevantConfig(issue) != null;
    }
}

