/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.model.validation.ErrorCollectionTransformer;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.jira.issue.fields.rest.FieldOperationHolder;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Function;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RestFieldSetOperationsHelper {
    public static final Set<String> SET_OPERATION = Collections.singleton(StandardOperation.SET.getName());
    private final ErrorCollectionTransformer errorCollectionTransformer;

    @Autowired
    public RestFieldSetOperationsHelper(ErrorCollectionTransformer errorCollectionTransformer) {
        this.errorCollectionTransformer = errorCollectionTransformer;
    }

    public ErrorCollection updateIssueInputParameters(List<FieldOperationHolder> operations, Function<JsonData, ServiceResult> updateFunc) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        for (FieldOperationHolder operationHolder : operations) {
            errors.addErrorCollection(this.handleOperation(operationHolder, updateFunc));
        }
        return errors;
    }

    private ErrorCollection handleOperation(FieldOperationHolder operationHolder, Function<JsonData, ServiceResult> updateFunc) {
        String operation = operationHolder.getOperation();
        StandardOperation standardOperation = StandardOperation.valueOf((String)operation.toUpperCase());
        switch (standardOperation) {
            case SET: {
                ServiceResult serviceResult = (ServiceResult)updateFunc.apply((Object)operationHolder.getData());
                return this.errorCollectionTransformer.toJiraErrorCollection(serviceResult.getErrors());
            }
        }
        return this.jiraError("gh.error.operation.not.valid", operation, StringUtils.join((Object[])StandardOperation.values(), (String)","));
    }

    private ErrorCollection jiraError(String messageKey, Object ... params) {
        return this.errorCollectionTransformer.toJiraErrorCollection(ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, messageKey, params).getErrors());
    }

    public Set<String> getSetOperation() {
        return SET_OPERATION;
    }
}

