/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public abstract class ReferencedEntityHistoryEntity {
    private final Long entityId;
    private final DateTime date;
    private final boolean added;
    private static final String LUCENE_VALUES_SEPARATOR = ";";
    private static final String LUCENE_VALUE_ADDED = "a";
    private static final String LUCENE_VALUE_REMOVED = "r";

    public ReferencedEntityHistoryEntity(Long entityId, DateTime date, boolean added) {
        this.entityId = entityId;
        this.date = date;
        this.added = added;
    }

    public static String getLuceneValuePrefix(Long entityId) {
        return entityId + LUCENE_VALUES_SEPARATOR;
    }

    public String toLuceneValue() {
        return this.entityId + LUCENE_VALUES_SEPARATOR + ISODateTimeFormat.dateTime().print((ReadableInstant)this.date) + LUCENE_VALUES_SEPARATOR + (this.added ? LUCENE_VALUE_ADDED : LUCENE_VALUE_REMOVED);
    }

    public DateTime getDate() {
        return this.date;
    }

    public boolean isAdded() {
        return this.added;
    }

    public long getReferencedEntityId() {
        return this.entityId;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

