/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.customfields.MultipleCustomFieldType;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CustomFieldUtil {
    private static final LoggerWrapper log = LoggerWrapper.with(CustomFieldUtil.class);

    @Nonnull
    public static Option<Options> getCustomFieldOptions(@Nonnull CustomField customField, @Nonnull FieldConfig fieldConfig) {
        Options options = customField.getOptions(null, fieldConfig, null);
        if (options == null) {
            log.warn("Expected custom field [id=%s, name=%s] to have nonnull options for field config %d but it did not.", customField.getId(), customField.getName(), fieldConfig.getId());
            return Option.none();
        }
        return Option.some((Object)options);
    }

    @Nonnull
    public static Option<Options> getCustomFieldOptions(@Nonnull CustomField customField, @Nonnull Option<FieldConfig> fieldConfig) {
        if (fieldConfig.isEmpty()) {
            log.warn("Expected custom field [id=%s, name=%s] field config to exist but it did not.", customField.getId(), customField.getName());
            return Option.none();
        }
        return CustomFieldUtil.getCustomFieldOptions(customField, (FieldConfig)fieldConfig.get());
    }

    @Nonnull
    public static Option<Options> getCustomFieldTypeOptions(@Nonnull MultipleCustomFieldType<?, ?> customFieldType, @Nonnull FieldConfig fieldConfig) {
        return CustomFieldUtil.getCustomFieldTypeOptions(customFieldType, fieldConfig, null);
    }

    @Nonnull
    public static Option<Options> getCustomFieldTypeOptions(@Nonnull MultipleCustomFieldType<?, ?> customFieldType, @Nonnull Option<FieldConfig> fieldConfig) {
        if (fieldConfig.isEmpty()) {
            return Option.none();
        }
        return CustomFieldUtil.getCustomFieldTypeOptions(customFieldType, (FieldConfig)fieldConfig.get(), null);
    }

    @Nonnull
    public static Option<Options> getCustomFieldTypeOptions(@Nonnull MultipleCustomFieldType<?, ?> customFieldType, @Nonnull FieldConfig fieldConfig, @Nullable JiraContextNode jiraContextNode) {
        Options options = customFieldType.getOptions(fieldConfig, jiraContextNode);
        if (options == null) {
            log.warn("Expected custom field type [name=%s] to have nonnull options for field config %d but it did not.", customFieldType.getName(), fieldConfig.getId());
            return Option.none();
        }
        return Option.some((Object)options);
    }

    @Nonnull
    public static Option<Options> getCustomFieldTypeOptions(@Nonnull MultipleCustomFieldType<?, ?> customFieldType, @Nonnull Option<FieldConfig> fieldConfig, @Nullable JiraContextNode jiraContextNode) {
        if (fieldConfig.isEmpty()) {
            return Option.none();
        }
        Options options = customFieldType.getOptions((FieldConfig)fieldConfig.get(), jiraContextNode);
        if (options == null) {
            log.warn("Expected custom field type [name=%s] to have nonnull options for field config %d but it did not.", customFieldType.getName(), ((FieldConfig)fieldConfig.get()).getId());
            return Option.none();
        }
        return Option.some((Object)options);
    }

    @Nonnull
    public static Option<FieldConfig> getOneAndOnlyConfig(@Nonnull CustomField field) {
        FieldConfig oneAndOnlyConfig;
        List schemes = field.getConfigurationSchemes();
        if (!schemes.isEmpty() && (oneAndOnlyConfig = ((FieldConfigScheme)schemes.iterator().next()).getOneAndOnlyConfig()) != null) {
            return Option.some((Object)oneAndOnlyConfig);
        }
        return Option.none();
    }

    @Nonnull
    public static Option<FieldConfig> getRelevantConfig(@Nonnull CustomField field, @Nonnull IssueContext issueContext) {
        FieldConfig relevantConfig = field.getRelevantConfig(issueContext);
        if (relevantConfig == null) {
            return Option.none();
        }
        return Option.some((Object)relevantConfig);
    }
}

