/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.customfield;

import com.atlassian.greenhopper.customfield.CustomFieldException;
import com.atlassian.greenhopper.customfield.CustomFieldMetadata;
import com.atlassian.greenhopper.customfield.CustomFieldService;
import com.atlassian.greenhopper.customfield.CustomFieldUtil;
import com.atlassian.greenhopper.customfield.JiraCustomFieldUtilsService;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.issue.fields.FieldCacheRefreshService;
import com.atlassian.greenhopper.manager.issue.fields.ManagedFieldRestrictor;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.issue.IssueTypePrototype;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.option.Options;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.ofbiz.core.entity.GenericValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="gh-customFieldService")
public class CustomFieldServiceImpl
implements CustomFieldService {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private CustomFieldManager customFieldManager;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private FieldConfigSchemeManager fieldConfigSchemeManager;
    @Autowired
    private FieldCacheRefreshService fieldCacheRefreshService;
    @Autowired
    private FieldVisibilityManager fieldVisibilityManager;
    @Autowired
    private FieldLayoutManager fieldLayoutManager;
    @Autowired
    private ManagedFieldRestrictor managedFieldRestrictor;
    @Autowired
    private IssueTypeService issueTypeService;
    @Autowired
    private OfBizDelegator ofBizDelegator;
    @Autowired
    private JiraCustomFieldUtilsService jiraCustomFieldUtils;

    @Override
    public CustomField createCustomField(CustomFieldMetadata fieldMetadata) {
        CustomField customField;
        I18n2 i18n = this.i18nFactoryService.getI18n();
        String name = i18n.getText(fieldMetadata.getFieldName());
        String desc = i18n.getText(fieldMetadata.getFieldDescription());
        CustomFieldType type = this.customFieldManager.getCustomFieldType(fieldMetadata.getFieldType());
        CustomFieldSearcher searcher = this.customFieldManager.getCustomFieldSearcher(fieldMetadata.getFieldSearcher());
        ContextData contexts = this.getContextDataForNewField(fieldMetadata.getIssueTypePrototypes());
        try {
            customField = this.customFieldManager.createCustomField(name, desc, type, searcher, contexts.contextNodes, contexts.issueTypes);
        }
        catch (Exception creationException) {
            throw new CustomFieldException("Exception while trying to create a customField with the following parameters: " + fieldMetadata, creationException);
        }
        if (fieldMetadata.isLockField()) {
            this.managedFieldRestrictor.lockField(customField);
        }
        return customField;
    }

    private ContextData getContextDataForNewField(Collection<IssueTypePrototype> prototypes) {
        if (prototypes.isEmpty() || prototypes.contains((Object)IssueTypePrototype.ALL)) {
            return this.allIssueTypesContext();
        }
        if (this.allIssueTypesExist(prototypes)) {
            return this.issueTypesContext(prototypes);
        }
        return this.noContext();
    }

    private boolean allIssueTypesExist(Collection<IssueTypePrototype> prototypes) {
        for (IssueTypePrototype prototype : prototypes) {
            if (this.issueTypeService.hasIssueTypeId(prototype)) continue;
            return false;
        }
        return true;
    }

    @Override
    public FieldConfigScheme associateCustomFieldContext(CustomField customField, CustomFieldMetadata customFieldMetadata) {
        return this.associateCustomFieldContext(customField, customFieldMetadata.getIssueTypePrototypes());
    }

    @Override
    public FieldConfigScheme associateCustomFieldContext(CustomField customField, Collection<IssueTypePrototype> prototypes) {
        ContextData contexts = this.issueTypesContext(prototypes);
        FieldConfigScheme fieldConfigScheme = this.fieldConfigSchemeManager.createDefaultScheme((ConfigurableField)customField, contexts.contextNodes, contexts.issueTypes);
        this.fieldCacheRefreshService.refreshAfterChangingCustomFieldContext(customField);
        return fieldConfigScheme;
    }

    ContextData noContext() {
        return new ContextData(null, null);
    }

    ContextData allIssueTypesContext() {
        return new ContextData(this.globalContext(), Lists.newArrayList((Object[])new IssueType[]{null}));
    }

    ContextData issueTypesContext(Collection<IssueTypePrototype> prototypes) {
        return new ContextData(this.globalContext(), this.resolveIssueTypes(prototypes));
    }

    private List<JiraContextNode> globalContext() {
        return this.jiraCustomFieldUtils.buildJiraIssueContexts(true, null);
    }

    private List<IssueType> resolveIssueTypes(Collection<IssueTypePrototype> prototypes) {
        String[] types = new String[prototypes.size()];
        int currentIndex = 0;
        for (IssueTypePrototype proto : prototypes) {
            types[currentIndex++] = this.issueTypeService.getIssueTypeId(proto);
        }
        return this.jiraCustomFieldUtils.buildIssueTypes(types);
    }

    @Override
    public void setOptionsOrderFromMetadata(CustomField customField, CustomFieldMetadata fieldMetadata) {
        List<String> optionValues = this.getOptionValuesFromNames(fieldMetadata.getOptionNames());
        for (IssueTypePrototype prototype : fieldMetadata.getIssueTypePrototypes()) {
            String issueTypeId = this.issueTypeService.getIssueTypeId(prototype);
            io.atlassian.fugue.Option<FieldConfig> fieldConfig = CustomFieldUtil.getRelevantConfig(customField, (IssueContext)new IssueContextImpl(null, issueTypeId));
            if (fieldConfig.isEmpty()) {
                this.log.warn("Could not find a Custom Field Configuration for field '%s', all projects and issue type '%s' -- therefore cannot find the Options for the field.", customField.getId(), issueTypeId);
                continue;
            }
            io.atlassian.fugue.Option<Options> optionsResult = CustomFieldUtil.getCustomFieldOptions(customField, fieldConfig);
            if (optionsResult.isEmpty()) continue;
            Options options = (Options)optionsResult.get();
            HashMap<Integer, Option> optionToPositionMap = new HashMap<Integer, Option>(options.size());
            List rootOptions = options.getRootOptions();
            if (optionValues.size() != options.size()) {
                throw new CustomFieldException("When setting custom field options order, available options must match initially created options");
            }
            for (Option option : rootOptions) {
                if (!optionValues.contains(option.getValue())) {
                    throw new CustomFieldException("When setting custom field options order, available options must match initially created options");
                }
                optionToPositionMap.put(optionValues.indexOf(option.getValue()), option);
            }
            options.moveOptionToPosition(optionToPositionMap);
        }
    }

    private List<String> getOptionValuesFromNames(List<String> optionNames) {
        final I18n2 i18n = this.i18nFactoryService.getI18n();
        return ImmutableList.copyOf((Iterable)Iterables.transform(optionNames, (Function)new Function<String, String>(){

            public String apply(@Nullable String optionName) {
                return i18n.getText(optionName);
            }
        }));
    }

    @Override
    public CustomField getCustomField(Long id) {
        return this.customFieldManager.getCustomFieldObject(id);
    }

    @Override
    public CustomField getCustomField(String id) {
        return this.customFieldManager.getCustomFieldObject(id);
    }

    @Override
    public void removeCustomField(CustomField customField) {
        try {
            this.customFieldManager.removeCustomField(customField);
        }
        catch (RemoveException e) {
            throw new CustomFieldException(e);
        }
    }

    @Override
    public <T extends CustomFieldType> List<CustomField> getCustomFields(Class<T> type) {
        return this.getCustomFields(type, true);
    }

    @Override
    public <T extends CustomFieldType> List<CustomField> getCustomFields(Class<T> type, boolean strict) {
        Validate.notNull(type, (String)"The Class for the CustomFieldType cannot be null", (Object[])new Object[0]);
        ArrayList<CustomField> fields = new ArrayList<CustomField>();
        for (CustomField customField : this.customFieldManager.getCustomFieldObjects()) {
            if (strict && customField.getCustomFieldType().getClass().equals(type)) {
                fields.add(customField);
                continue;
            }
            if (strict || !type.isAssignableFrom(customField.getCustomFieldType().getClass())) continue;
            fields.add(customField);
        }
        return fields;
    }

    @Override
    public boolean isUniqueFieldName(CustomField customField) {
        Collection customFields = this.customFieldManager.getCustomFieldObjectsByName(customField.getName());
        if (customFields == null || customFields.size() != 1) {
            return false;
        }
        return !this.isSystemFieldName(customField.getName());
    }

    @Override
    public boolean isSystemFieldName(String fieldName) {
        for (String name : SystemSearchConstants.getSystemNames()) {
            if (!name.equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFieldApplicable(CustomField customField, Issue issue) {
        return this.isFieldApplicable(customField, issue.getProjectObject().getId(), issue.getIssueTypeObject().getId());
    }

    @Override
    public boolean isFieldApplicable(CustomField customField, Long projectId, String issueTypeId) {
        IssueContextImpl issueContext = new IssueContextImpl(projectId, issueTypeId);
        FieldConfig config = this.fieldConfigSchemeManager.getRelevantConfig((IssueContext)issueContext, (ConfigurableField)customField);
        return config != null;
    }

    @Override
    public boolean isFieldVisible(CustomField customField, Issue issue) {
        return this.fieldVisibilityManager.isCustomFieldVisible(issue.getProjectObject().getId(), customField.getIdAsLong(), issue.getIssueTypeObject().getId());
    }

    @Override
    public void makeFieldRequired(CustomField field) {
        List layouts = this.fieldLayoutManager.getEditableFieldLayouts();
        for (EditableFieldLayout layout : layouts) {
            FieldLayoutItem fieldLayoutItem = layout.getFieldLayoutItem(field.getId());
            if (fieldLayoutItem == null) continue;
            layout.makeRequired(fieldLayoutItem);
            if (layout.isDefault()) {
                this.fieldLayoutManager.storeEditableDefaultFieldLayout((EditableDefaultFieldLayout)layout);
                continue;
            }
            this.fieldLayoutManager.storeEditableFieldLayout(layout);
        }
    }

    @Override
    public boolean verifyCustomFieldExistsInDB(Long customFieldId) {
        GenericValue customField = this.ofBizDelegator.findById("CustomField", customFieldId);
        return customField != null;
    }

    @Override
    public boolean verifyCustomFieldExistsInDB(String customFieldId) {
        String[] segments;
        if (customFieldId != null && customFieldId.startsWith("customfield_") && (segments = customFieldId.split("_")).length == 2) {
            return this.verifyCustomFieldExistsInDB(Long.valueOf(segments[1]));
        }
        return false;
    }

    private class ContextData {
        final List<JiraContextNode> contextNodes;
        final List<IssueType> issueTypes;

        ContextData(List<JiraContextNode> contextNodes, List<IssueType> issueTypes) {
            this.contextNodes = contextNodes;
            this.issueTypes = issueTypes;
        }
    }
}

